/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.commons.caservice.impl;

import io.wcm.sling.commons.caservice.ContextAwareService;
import io.wcm.sling.commons.caservice.impl.ServiceInfo;
import java.util.stream.Stream;
import org.apache.sling.commons.osgi.Order;
import org.apache.sling.commons.osgi.RankedServices;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContextAwareServiceTracker<S extends ContextAwareService>
implements ServiceTrackerCustomizer<S, ServiceInfo<S>> {
    private final String serviceClassName;
    private final BundleContext bundleContext;
    private final ServiceTracker<S, ServiceInfo<S>> serviceTracker;
    private volatile RankedServices<ServiceInfo<S>> rankedServices;
    private volatile long lastServiceChange;
    private static final Logger log = LoggerFactory.getLogger(ContextAwareServiceTracker.class);

    ContextAwareServiceTracker(@NotNull String serviceClassName, @NotNull BundleContext bundleContext) {
        this.serviceClassName = serviceClassName;
        this.bundleContext = bundleContext;
        this.rankedServices = new RankedServices(Order.DESCENDING);
        this.serviceTracker = new ServiceTracker(bundleContext, serviceClassName, (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
    }

    public void dispose() {
        this.serviceTracker.close();
        this.rankedServices = null;
    }

    public ServiceInfo addingService(ServiceReference<S> reference) {
        ServiceInfo<BundleContext> serviceInfo = new ServiceInfo<BundleContext>((ServiceReference<BundleContext>)reference, this.bundleContext);
        ContextAwareServiceTracker.logServiceDebugMessage("Add service {}: {}", serviceInfo);
        if (this.rankedServices != null) {
            this.rankedServices.bind(serviceInfo, serviceInfo.getServiceProperties());
        }
        this.lastServiceChange = System.currentTimeMillis();
        return serviceInfo;
    }

    public void modifiedService(ServiceReference<S> reference, ServiceInfo<S> serviceInfo) {
    }

    public void removedService(ServiceReference<S> reference, ServiceInfo<S> serviceInfo) {
        ContextAwareServiceTracker.logServiceDebugMessage("Remove service {}: {}", serviceInfo);
        if (this.rankedServices != null) {
            this.rankedServices.unbind(serviceInfo, serviceInfo.getServiceProperties());
        }
        this.lastServiceChange = System.currentTimeMillis();
        this.bundleContext.ungetService(reference);
    }

    public Stream<ServiceInfo<S>> resolve(@Nullable String resourcePath) {
        if (this.rankedServices == null) {
            return Stream.empty();
        }
        return this.rankedServices.getList().stream().filter(serviceInfo -> serviceInfo.matches(resourcePath));
    }

    public String getServiceClassName() {
        return this.serviceClassName;
    }

    public long getLastServiceChangeTimestamp() {
        return this.lastServiceChange;
    }

    public Iterable<ServiceInfo<S>> getServiceInfos() {
        return this.rankedServices;
    }

    private static void logServiceDebugMessage(String message, ServiceInfo<?> serviceInfo) {
        if (!log.isDebugEnabled()) {
            return;
        }
        Object service = serviceInfo.getService();
        if (service != null) {
            log.debug(message, (Object)service.getClass().getName(), serviceInfo);
        }
    }
}

