/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.commons.caservice.impl;

import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.commons.WCMUtils;
import io.wcm.sling.commons.caservice.PathPreprocessor;
import javax.servlet.ServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.Nullable;

class ResourcePathResolver {
    private final PathPreprocessor pathPreprocessor;

    ResourcePathResolver(@Nullable PathPreprocessor pathPreprocessor) {
        this.pathPreprocessor = pathPreprocessor;
    }

    @Nullable
    public String get(@Nullable Adaptable adaptable) {
        Resource resource = this.getResourceFromAdaptable(adaptable);
        String path = null;
        if (resource != null) {
            path = resource.getPath();
            if (this.pathPreprocessor != null) {
                path = this.pathPreprocessor.apply(path, resource.getResourceResolver());
            }
        }
        return path;
    }

    @Nullable
    private Resource getResourceFromAdaptable(@Nullable Adaptable adaptable) {
        if (adaptable instanceof Resource) {
            return (Resource)adaptable;
        }
        if (adaptable instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest request = (SlingHttpServletRequest)adaptable;
            ComponentContext wcmComponentContext = WCMUtils.getComponentContext((ServletRequest)request);
            if (wcmComponentContext != null && wcmComponentContext.getPage() != null) {
                return wcmComponentContext.getPage().getContentResource();
            }
            return request.getResource();
        }
        return null;
    }
}

