/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.commons.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class Escape {
    private static final char LIKE_ESCAPE_CHARACTER = '\\';
    private static final Set<Character> LIKE_SPECIAL_CHARACTERS = Set.of(Character.valueOf('%'), Character.valueOf('_'));

    private Escape() {
    }

    @NotNull
    public static String urlEncode(@Nullable String value) {
        if (value == null) {
            return "";
        }
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @NotNull
    public static String validName(@NotNull String value) {
        String text = value.toLowerCase();
        text = StringUtils.replace((String)text, (String)"\u00e4", (String)"ae");
        text = StringUtils.replace((String)text, (String)"\u00f6", (String)"oe");
        text = StringUtils.replace((String)text, (String)"\u00fc", (String)"ue");
        text = StringUtils.replace((String)text, (String)"\u00df", (String)"ss");
        StringBuilder sb = new StringBuilder(text);
        for (int i = 0; i < sb.length(); ++i) {
            char ch = sb.charAt(i);
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_') continue;
            ch = '-';
            sb.setCharAt(i, ch);
        }
        return sb.toString();
    }

    @NotNull
    public static String validFilename(@NotNull String value) {
        String fileExtension = StringUtils.substringAfterLast((String)value, (String)".");
        String fileName = StringUtils.substringBeforeLast((String)value, (String)".");
        if (StringUtils.isEmpty((CharSequence)fileExtension)) {
            return Escape.validName(fileName);
        }
        return Escape.validName(fileName) + "." + Escape.validName(fileExtension);
    }

    @NotNull
    public static String jcrQueryLiteral(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException("Invalid query string value: " + value);
        }
        return "'" + StringUtils.replace((String)value, (String)"'", (String)"''") + "'";
    }

    @NotNull
    public static String jcrQueryContainsExpr(@NotNull String value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Invalid query string value: " + value);
        }
        return Escape.jcrQueryLiteral(Text.escapeIllegalXpathSearchChars((String)value));
    }

    @NotNull
    public static String jcrQueryLikeString(@NotNull String value) {
        StringBuilder escaped = new StringBuilder();
        for (char c : value.toCharArray()) {
            if (LIKE_SPECIAL_CHARACTERS.contains(Character.valueOf(c)) || c == '\\') {
                escaped.append(Character.valueOf('\\'));
            }
            escaped.append(c);
        }
        return escaped.toString();
    }
}

