/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.models.injectors.impl;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ModelsImplConfiguration.class}, immediate=true)
@Designate(ocd=Config.class)
public class ModelsImplConfiguration {
    private boolean requestThreadLocal;

    @Activate
    private void activate(Config config) {
        this.requestThreadLocal = config.requestThreadLocal();
    }

    public boolean isRequestThreadLocal() {
        return this.requestThreadLocal;
    }

    @ObjectClassDefinition(name="wcm.io Models Configuration", description="Configures behavior of the wcm.io Injectors for Sling Models")
    static @interface Config {
        @AttributeDefinition(name="Request Thread Local", description="Enables the thread-local based injection of all request-derived objects in AEM Object and Sling Object injectors. These objects can than always be injected regardless of the adaptable.")
        public boolean requestThreadLocal() default true;
    }
}

