/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.sling.models.injectors.impl;

import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.i18n.I18n;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.AuthoringUIMode;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.commons.WCMUtils;
import io.wcm.sling.commons.request.RequestContext;
import io.wcm.sling.models.annotations.AemObject;
import io.wcm.sling.models.injectors.impl.ModelsImplConfiguration;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.spi.AcceptsNullName;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.injectorspecific.AbstractInjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Injector.class, StaticInjectAnnotationProcessorFactory.class}, property={"service.ranking:Integer=4400"})
public final class AemObjectInjector
implements Injector,
StaticInjectAnnotationProcessorFactory,
AcceptsNullName {
    @NotNull
    public static final String NAME = "wcm-io-aem-object";
    static final String RESOURCE_PAGE = "resourcePage";
    static final String USER_I18N = "userI18n";
    @Reference
    private RequestContext requestContext;
    @Reference
    private ModelsImplConfiguration modelsImplConfiguration;

    @NotNull
    public String getName() {
        return NAME;
    }

    public Object getValue(@NotNull Object adaptable, String name, @NotNull Type type, @NotNull AnnotatedElement element, @NotNull DisposalCallbackRegistry callbackRegistry) {
        if (!(type instanceof Class)) {
            return null;
        }
        Class requestedClass = (Class)type;
        SlingHttpServletRequest request = this.getRequest(adaptable);
        if (request != null) {
            if (requestedClass.equals(WCMMode.class)) {
                return this.getWcmMode(request);
            }
            if (requestedClass.equals(AuthoringUIMode.class)) {
                return this.getAuthoringUiMode(request);
            }
            if (requestedClass.equals(ComponentContext.class)) {
                return this.getComponentContext(request);
            }
            if (requestedClass.equals(Style.class)) {
                return this.getStyle(request);
            }
            if (requestedClass.equals(XSSAPI.class)) {
                return this.getXssApi(request);
            }
            if (requestedClass.equals(I18n.class)) {
                if (StringUtils.equals((CharSequence)name, (CharSequence)USER_I18N)) {
                    return this.getUserI18n(request);
                }
                return this.getResourceI18n(request);
            }
        }
        if (requestedClass.equals(PageManager.class)) {
            return this.getPageManager(adaptable);
        }
        if (requestedClass.equals(Page.class)) {
            if (StringUtils.equals((CharSequence)name, (CharSequence)RESOURCE_PAGE)) {
                return this.getResourcePage(adaptable);
            }
            return this.getCurrentPage(adaptable);
        }
        if (requestedClass.equals(Designer.class)) {
            return this.getDesigner(adaptable);
        }
        if (requestedClass.equals(Design.class)) {
            return this.getCurrentDesign(adaptable);
        }
        if (requestedClass.equals(TagManager.class)) {
            return this.getTagManager(adaptable);
        }
        if (requestedClass.equals(WorkflowSession.class)) {
            return this.getWorkflowSession(adaptable);
        }
        return null;
    }

    @Nullable
    private SlingHttpServletRequest getRequest(@NotNull Object adaptable) {
        if (adaptable instanceof SlingHttpServletRequest) {
            return (SlingHttpServletRequest)adaptable;
        }
        if (this.modelsImplConfiguration.isRequestThreadLocal()) {
            return this.requestContext.getThreadRequest();
        }
        return null;
    }

    @Nullable
    private ResourceResolver getResourceResolver(@NotNull Object adaptable) {
        Resource resource;
        if (adaptable instanceof ResourceResolver) {
            return (ResourceResolver)adaptable;
        }
        if (adaptable instanceof Resource) {
            return ((Resource)adaptable).getResourceResolver();
        }
        if (adaptable instanceof Page && (resource = (Resource)((Page)adaptable).adaptTo(Resource.class)) != null) {
            return resource.getResourceResolver();
        }
        SlingHttpServletRequest request = this.getRequest(adaptable);
        if (request != null) {
            return request.getResourceResolver();
        }
        return null;
    }

    @Nullable
    private Resource getResource(@NotNull Object adaptable) {
        if (adaptable instanceof Resource) {
            return (Resource)adaptable;
        }
        if (adaptable instanceof Page) {
            return (Resource)((Page)adaptable).adaptTo(Resource.class);
        }
        SlingHttpServletRequest request = this.getRequest(adaptable);
        if (request != null) {
            return request.getResource();
        }
        return null;
    }

    @Nullable
    private PageManager getPageManager(@NotNull Object adaptable) {
        ResourceResolver resolver = this.getResourceResolver(adaptable);
        if (resolver != null) {
            return (PageManager)resolver.adaptTo(PageManager.class);
        }
        return null;
    }

    @Nullable
    private Designer getDesigner(@NotNull Object adaptable) {
        ResourceResolver resolver = this.getResourceResolver(adaptable);
        if (resolver != null) {
            return (Designer)resolver.adaptTo(Designer.class);
        }
        return null;
    }

    @Nullable
    private Page getCurrentPage(@NotNull Object adaptable) {
        ComponentContext context;
        SlingHttpServletRequest request = this.getRequest(adaptable);
        if (request != null && (context = this.getComponentContext(request)) != null) {
            return context.getPage();
        }
        return this.getResourcePage(adaptable);
    }

    @Nullable
    private Page getResourcePage(@NotNull Object adaptable) {
        PageManager pageManager = this.getPageManager(adaptable);
        Resource resource = this.getResource(adaptable);
        if (pageManager != null && resource != null) {
            return pageManager.getContainingPage(resource);
        }
        return null;
    }

    @NotNull
    private WCMMode getWcmMode(@NotNull SlingHttpServletRequest request) {
        return WCMMode.fromRequest((ServletRequest)request);
    }

    @NotNull
    private AuthoringUIMode getAuthoringUiMode(@NotNull SlingHttpServletRequest request) {
        AuthoringUIMode mode = AuthoringUIMode.fromRequest((ServletRequest)request);
        if (mode == null) {
            mode = AuthoringUIMode.TOUCH;
        }
        return mode;
    }

    @Nullable
    private ComponentContext getComponentContext(@NotNull SlingHttpServletRequest request) {
        return WCMUtils.getComponentContext((ServletRequest)request);
    }

    @Nullable
    private Design getCurrentDesign(Object adaptable) {
        Page currentPage = this.getCurrentPage(adaptable);
        Designer designer = this.getDesigner(adaptable);
        if (currentPage != null && designer != null) {
            return designer.getDesign(currentPage);
        }
        return null;
    }

    @Nullable
    private Style getStyle(@NotNull SlingHttpServletRequest request) {
        Style style = null;
        SlingBindings slingBindings = this.getSlingBindings(request);
        if (slingBindings != null) {
            style = (Style)slingBindings.get((Object)"currentStyle");
        }
        if (style == null) {
            Design currentDesign = this.getCurrentDesign(request);
            ComponentContext componentContext = this.getComponentContext(request);
            if (currentDesign != null && componentContext != null) {
                style = currentDesign.getStyle(componentContext.getCell());
            }
        }
        return style;
    }

    @Nullable
    private XSSAPI getXssApi(@NotNull SlingHttpServletRequest request) {
        return (XSSAPI)request.adaptTo(XSSAPI.class);
    }

    @Nullable
    private I18n getResourceI18n(@NotNull SlingHttpServletRequest request) {
        Page currentPage = this.getCurrentPage(request);
        if (currentPage != null) {
            Locale currentLocale = currentPage.getLanguage(false);
            return new I18n(this.getI18nEnabledRequest(request).getResourceBundle(currentLocale));
        }
        return null;
    }

    @NotNull
    private I18n getUserI18n(@NotNull SlingHttpServletRequest request) {
        return new I18n((HttpServletRequest)this.getI18nEnabledRequest(request));
    }

    @Nullable
    private TagManager getTagManager(@NotNull Object adaptable) {
        ResourceResolver resolver = this.getResourceResolver(adaptable);
        if (resolver != null) {
            return (TagManager)resolver.adaptTo(TagManager.class);
        }
        return null;
    }

    @Nullable
    private WorkflowSession getWorkflowSession(@NotNull Object adaptable) {
        ResourceResolver resolver = this.getResourceResolver(adaptable);
        if (resolver != null) {
            return (WorkflowSession)resolver.adaptTo(WorkflowSession.class);
        }
        return null;
    }

    @NotNull
    private SlingHttpServletRequest getI18nEnabledRequest(@NotNull SlingHttpServletRequest request) {
        SlingHttpServletRequest threadLocalRequest;
        SlingHttpServletRequest bindingsRequest;
        SlingBindings bindings = this.getSlingBindings(request);
        if (bindings != null && (bindingsRequest = bindings.getRequest()) != null) {
            return bindingsRequest;
        }
        if (this.modelsImplConfiguration.isRequestThreadLocal() && (threadLocalRequest = this.requestContext.getThreadRequest()) != null) {
            return threadLocalRequest;
        }
        return request;
    }

    @Nullable
    private SlingBindings getSlingBindings(@NotNull SlingHttpServletRequest request) {
        return (SlingBindings)request.getAttribute(SlingBindings.class.getName());
    }

    public InjectAnnotationProcessor2 createAnnotationProcessor(AnnotatedElement element) {
        AemObject annotation = element.getAnnotation(AemObject.class);
        if (annotation != null) {
            return new AemObjectAnnotationProcessor(annotation);
        }
        return null;
    }

    private static class AemObjectAnnotationProcessor
    extends AbstractInjectAnnotationProcessor2 {
        private final AemObject annotation;

        AemObjectAnnotationProcessor(AemObject annotation) {
            this.annotation = annotation;
        }

        public InjectionStrategy getInjectionStrategy() {
            return this.annotation.injectionStrategy();
        }

        public Boolean isOptional() {
            return this.annotation.optional();
        }
    }
}

