/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.commons.Filter;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagConstants;
import com.day.cq.tagging.TagManager;
import io.wcm.testing.mock.aem.MockTagManager;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;

class MockTag
extends SlingAdaptable
implements Tag,
Comparable<Tag> {
    private final Resource resource;

    MockTag(@NotNull Resource resource) {
        if (resource == null) {
            throw new NullPointerException("resource is null");
        }
        if (!resource.getPath().startsWith(MockTagManager.getTagRootPath() + "/")) {
            throw new IllegalArgumentException("Tags should exist under " + MockTagManager.getTagRootPath());
        }
        this.resource = resource;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)o;
        Resource tagResource = (Resource)tag.adaptTo(Resource.class);
        return this.resource.getResourceResolver().equals(tagResource.getResourceResolver()) && this.resource.getPath().equals(tagResource.getPath());
    }

    public int hashCode() {
        return this.resource.getPath().hashCode();
    }

    @Override
    public int compareTo(Tag tag) {
        Resource tagResource = (Resource)tag.adaptTo(Resource.class);
        return this.resource.getPath().compareTo(tagResource.getPath());
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append("Tag [");
        string.append("path=").append(this.getPath());
        string.append(", title=").append(this.getTitle());
        string.append(", desc=").append(this.getDescription());
        string.append("]");
        return string.toString();
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Resource.class) {
            return (AdapterType)this.resource;
        }
        Object result = super.adaptTo(type);
        if (result == null) {
            result = this.resource.adaptTo(type);
        }
        return (AdapterType)result;
    }

    public Iterator<Resource> find() {
        TagManager tagManager = (TagManager)this.resource.getResourceResolver().adaptTo(TagManager.class);
        return tagManager.find(this.getPath());
    }

    public long getCount() {
        TagManager tagManager = (TagManager)this.resource.getResourceResolver().adaptTo(TagManager.class);
        return tagManager.find(this.getPath()).getSize();
    }

    public String getDescription() {
        return (String)this.resource.getValueMap().get("jcr:description", String.class);
    }

    public long getLastModified() {
        Calendar lastMod = (Calendar)this.resource.getValueMap().get("jcr:lastModified", Calendar.class);
        if (lastMod == null) {
            return 0L;
        }
        return lastMod.getTimeInMillis();
    }

    public String getLastModifiedBy() {
        return (String)this.resource.getValueMap().get("jcr:lastModifiedBy", String.class);
    }

    public String getLocalTagID() {
        if (this.isNamespace()) {
            return "";
        }
        String tagID = this.getTagID();
        tagID = tagID.substring(tagID.indexOf(TagConstants.NAMESPACE_DELIMITER) + 1);
        return tagID;
    }

    public String getLocalizedTitle(Locale locale) {
        if (locale == null) {
            return null;
        }
        ValueMap properties = this.resource.getValueMap();
        String localeStr = locale.getLanguage() + "_" + locale.getCountry();
        String title = (String)properties.get("jcr:title." + localeStr, String.class);
        if (title == null) {
            localeStr = locale.getLanguage();
            title = (String)properties.get("jcr:title." + localeStr, String.class);
        }
        return title;
    }

    public Map<Locale, String> getLocalizedTitles() {
        ValueMap properties = this.resource.getValueMap();
        HashMap<Locale, String> localeTitles = new HashMap<Locale, String>();
        for (Map.Entry propEntry : properties.entrySet()) {
            String propName = (String)propEntry.getKey();
            if (!propName.startsWith("jcr:title.")) continue;
            String localeName = propName.substring("jcr:title".length() + 1);
            Locale locale = LanguageUtil.getLocale((String)localeName);
            localeTitles.put(locale, propEntry.getValue().toString());
        }
        return localeTitles;
    }

    public String getName() {
        return this.resource.getName();
    }

    public Tag getNamespace() {
        if (this.isNamespace()) {
            return this;
        }
        MockTag namespace = this;
        while (!namespace.isNamespace()) {
            namespace = namespace.getParent();
        }
        return namespace;
    }

    public Tag getParent() {
        if (this.isNamespace()) {
            return null;
        }
        return (Tag)this.resource.getParent().adaptTo(Tag.class);
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public String getTagID() {
        StringBuilder tagID = new StringBuilder(this.resource.getPath().length());
        MockTag tag = this;
        while (!tag.isNamespace()) {
            Resource tagResource = (Resource)tag.adaptTo(Resource.class);
            if (tagID.length() != 0) {
                tagID.insert(0, "/");
            }
            tagID.insert(0, tagResource.getName());
            tag = tag.getParent();
        }
        tagID.insert(0, TagConstants.NAMESPACE_DELIMITER);
        tagID.insert(0, ((Resource)tag.adaptTo(Resource.class)).getName());
        return tagID.toString();
    }

    public String getTitle() {
        return (String)this.resource.getValueMap().get("jcr:title", (Object)this.getName());
    }

    public String getTitle(Locale locale) {
        String title = this.getLocalizedTitle(locale);
        if (title == null) {
            title = this.getTitle();
        }
        return title;
    }

    public boolean isNamespace() {
        return MockTagManager.getTagRootPath().equals(this.resource.getParent().getPath());
    }

    public Iterator<Tag> listAllSubTags() {
        return this.listChildren(null, true);
    }

    public Iterator<Tag> listChildren() {
        return this.listChildren(null, false);
    }

    private Iterator<Tag> listChildren(Filter<Tag> filter, boolean recurse) {
        LinkedList<Tag> tags = new LinkedList<Tag>();
        LinkedList resources = new LinkedList();
        CollectionUtils.addAll(resources, (Iterator)this.resource.listChildren());
        while (!resources.isEmpty()) {
            Tag tag;
            Resource tagResource = (Resource)resources.poll();
            if (recurse) {
                CollectionUtils.addAll(resources, (Iterator)tagResource.listChildren());
            }
            if ((tag = (Tag)tagResource.adaptTo(Tag.class)) == null || filter != null && !filter.includes((Object)tag)) continue;
            tags.add(tag);
        }
        return tags.iterator();
    }

    public Iterator<Tag> listChildren(Filter<Tag> filter) {
        return this.listChildren(filter, false);
    }

    public String getXPathSearchExpression(String property) {
        String tagRoot = MockTagManager.getTagRootPath();
        String ns = this.getNamespace().getName();
        String relPath = StringUtils.substringAfter((String)this.getPath(), (String)(tagRoot + "/" + ns + "/"));
        boolean isDefaultNamespace = StringUtils.equals((CharSequence)ns, (CharSequence)"default");
        if (isDefaultNamespace) {
            return "(@" + property + "='" + relPath + "' or @" + property + "='" + tagRoot + "/" + ns + "/" + relPath + "' or jcr:like(@" + property + ", '" + relPath + "/%') or jcr:like(@" + property + ", '" + tagRoot + "/" + ns + "/" + relPath + "/%'))";
        }
        return "(@" + property + "='" + ns + ":" + relPath + "' or @" + property + "='" + tagRoot + "/" + ns + "/" + relPath + "' or jcr:like(@" + property + ", '" + ns + ":" + relPath + "/%') or jcr:like(@" + property + ", '" + tagRoot + "/" + ns + "/" + relPath + "/%'))";
    }

    public String getGQLSearchExpression(String arg0) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public Map<Locale, String> getLocalizedTitlePaths() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public String getTitlePath() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public String getTitlePath(Locale arg0) {
        throw new UnsupportedOperationException("Unsupported operation");
    }
}

