/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.builder;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.api.Rendition;
import com.day.cq.tagging.InvalidTagFormatException;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import com.day.image.Layer;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.sling.loader.ContentLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class ContentBuilder
extends org.apache.sling.testing.mock.sling.builder.ContentBuilder {
    @NotNull
    static final String DUMMY_TEMPLATE = "/apps/sample/templates/template1";
    private static final Map<String, byte[]> DUMMY_IMAGE_CACHE = new HashMap<String, byte[]>();

    public ContentBuilder(@NotNull ResourceResolver resourceResolver) {
        super(resourceResolver);
    }

    public Page page(@NotNull String path) {
        return this.page(path, DUMMY_TEMPLATE, (Map<String, Object>)ValueMap.EMPTY);
    }

    public Page page(@NotNull String path, @Nullable String template) {
        return this.page(path, template, (Map<String, Object>)ValueMap.EMPTY);
    }

    public Page page(@NotNull String path, @Nullable String template, @NotNull String title) {
        return this.page(path, template, (Map<String, Object>)ImmutableMap.builder().put((Object)"jcr:title", (Object)title).build());
    }

    public Page page(@NotNull String path, @Nullable String template, @NotNull Map<String, Object> pageProperties) {
        String parentPath = ResourceUtil.getParent((String)path);
        if (parentPath == null) {
            throw new IllegalArgumentException("Resource has no parent: " + path);
        }
        this.ensureResourceExists(parentPath);
        String name = ResourceUtil.getName((String)path);
        try {
            PageManager pageManager = (PageManager)this.resourceResolver.adaptTo(PageManager.class);
            Page page = pageManager.create(parentPath, name, template, name, true);
            if (!pageProperties.isEmpty()) {
                ModifiableValueMap props = (ModifiableValueMap)page.getContentResource().adaptTo(ModifiableValueMap.class);
                props.putAll(pageProperties);
                this.resourceResolver.commit();
            }
            return page;
        }
        catch (WCMException | PersistenceException ex) {
            throw new RuntimeException("Unable to create page at " + path, ex);
        }
    }

    public Page page(@NotNull String path, @Nullable String template, Object ... pageProperties) {
        return this.page(path, template, MapUtil.toMap((Object[])pageProperties));
    }

    public Asset asset(@NotNull String path, @NotNull String classpathResource, @NotNull String mimeType) {
        return this.asset(path, classpathResource, mimeType, (Map<String, Object>)null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Asset asset(@NotNull String path, @NotNull String classpathResource, @NotNull String mimeType, @Nullable Map<String, Object> metadata) {
        try (InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);){
            if (is == null) {
                throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
            }
            Asset asset = this.asset(path, is, mimeType, metadata);
            return asset;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Asset asset(@NotNull String path, @NotNull String classpathResource, @NotNull String mimeType, Object ... metadata) {
        return this.asset(path, classpathResource, mimeType, (Map<String, Object>)MapUtil.toMap((Object[])metadata));
    }

    public Asset asset(@NotNull String path, int width, int height, @NotNull String mimeType) {
        return this.asset(path, width, height, mimeType, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Asset asset(@NotNull String path, int width, int height, @NotNull String mimeType, @Nullable Map<String, Object> metadata) {
        try (InputStream is = ContentBuilder.createDummyImage(width, height, mimeType);){
            Asset asset = this.asset(path, is, mimeType, metadata);
            return asset;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Asset asset(@NotNull String path, int width, int height, @NotNull String mimeType, Object ... metadata) {
        return this.asset(path, width, height, mimeType, MapUtil.toMap((Object[])metadata));
    }

    public Asset asset(@NotNull String path, @NotNull InputStream inputStream, @NotNull String mimeType) {
        return this.asset(path, inputStream, mimeType, (Map<String, Object>)null);
    }

    public Asset asset(@NotNull String path, @NotNull InputStream inputStream, @NotNull String mimeType, @Nullable Map<String, Object> metadata) {
        AssetManager assetManager = (AssetManager)this.resourceResolver.adaptTo(AssetManager.class);
        Asset asset = assetManager.createAsset(path, inputStream, mimeType, true);
        if (metadata != null && !metadata.isEmpty()) {
            String metadataPath = asset.getPath() + "/" + "jcr:content" + "/" + "metadata";
            Resource metadataResource = this.resourceResolver.getResource(metadataPath);
            if (metadataResource == null) {
                metadataResource = this.resource(metadataPath);
            }
            ModifiableValueMap metadataProperties = (ModifiableValueMap)metadataResource.adaptTo(ModifiableValueMap.class);
            metadataProperties.putAll(metadata);
        }
        return asset;
    }

    public Asset asset(@NotNull String path, @NotNull InputStream inputStream, @NotNull String mimeType, Object ... metadata) {
        return this.asset(path, inputStream, mimeType, (Map<String, Object>)MapUtil.toMap((Object[])metadata));
    }

    @NotNull
    public static InputStream createDummyImage(int width, int height, String mimeType) {
        String key = width + "x" + height + ":" + mimeType;
        byte[] data = DUMMY_IMAGE_CACHE.get(key);
        if (data == null) {
            Layer layer = new Layer(width, height, null);
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                double quality = StringUtils.equals((CharSequence)mimeType, (CharSequence)"image/gif") ? 256.0 : 1.0;
                layer.write(mimeType, quality, (OutputStream)bos);
                data = bos.toByteArray();
                DUMMY_IMAGE_CACHE.put(key, data);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return new ByteArrayInputStream(data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Rendition assetRendition(@NotNull Asset asset, @NotNull String name, @NotNull String classpathResource, @NotNull String mimeType) {
        try (InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);){
            if (is == null) {
                throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
            }
            Rendition rendition = this.assetRendition(asset, name, is, mimeType);
            return rendition;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Rendition assetRendition(@NotNull Asset asset, @NotNull String name, int width, int height, @NotNull String mimeType) {
        try (InputStream is = ContentBuilder.createDummyImage(width, height, mimeType);){
            Rendition rendition = this.assetRendition(asset, name, is, mimeType);
            return rendition;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Rendition assetRendition(@NotNull Asset asset, String name, @NotNull InputStream inputStream, @NotNull String mimeType) {
        return asset.addRendition(name, inputStream, mimeType);
    }

    public Tag tag(@NotNull String tagId) {
        TagManager tagManager = (TagManager)this.resourceResolver.adaptTo(TagManager.class);
        String tagTitle = ResourceUtil.getName((String)StringUtils.substringAfter((String)tagId, (String)":"));
        try {
            return tagManager.createTag(tagId, tagTitle, null, true);
        }
        catch (InvalidTagFormatException | AccessControlException ex) {
            throw new RuntimeException("Unable to create tag: " + tagId, ex);
        }
    }

    @NotNull
    public final Resource resource(@NotNull Page page, @NotNull String name) {
        return this.resource(page, name, (Map<String, Object>)ValueMap.EMPTY);
    }

    @NotNull
    public final Resource resource(@NotNull Page page, @NotNull String name, @NotNull Map<String, Object> properties) {
        String path = page.getContentResource().getPath() + "/" + StringUtils.stripStart((String)name, (String)"/");
        return this.resource(path, properties);
    }

    @NotNull
    public final Resource resource(@NotNull Page page, @NotNull String name, Object ... properties) {
        return this.resource(page, name, MapUtil.toMap((Object[])properties));
    }
}

