/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.components.ComponentManager;
import com.day.cq.wcm.api.designer.Designer;
import io.wcm.testing.mock.aem.MockAsset;
import io.wcm.testing.mock.aem.MockAssetManager;
import io.wcm.testing.mock.aem.MockComponentManager;
import io.wcm.testing.mock.aem.MockDesigner;
import io.wcm.testing.mock.aem.MockPage;
import io.wcm.testing.mock.aem.MockPageManager;
import io.wcm.testing.mock.aem.MockRendition;
import io.wcm.testing.mock.aem.MockTag;
import io.wcm.testing.mock.aem.MockTagManager;
import io.wcm.testing.mock.aem.MockTemplate;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;

@Component(service={AdapterFactory.class}, property={"adaptables=org.apache.sling.api.resource.Resource", "adaptables=org.apache.sling.api.resource.ResourceResolver", "adapters=com.day.cq.wcm.api.Page", "adapters=com.day.cq.wcm.api.PageManager", "adapters=com.day.cq.wcm.api.Template", "adapters=com.day.cq.wcm.api.components.ComponentManager", "adapters=com.day.cq.dam.api.Asset", "adapters=com.day.cq.dam.api.AssetManager", "adapters=com.day.cq.dam.api.Rendition", "adapters=com.day.cq.tagging.TagManager", "adapters=com.day.cq.tagging.Tag", "adapters=com.day.cq.wcm.api.designer.Designer"})
@ProviderType
public class MockAemAdapterFactory
implements AdapterFactory {
    @Reference
    private EventAdmin eventAdmin;

    @Nullable
    public <AdapterType> AdapterType getAdapter(@NotNull Object adaptable, @NotNull Class<AdapterType> type) {
        if (adaptable instanceof Resource) {
            return this.getAdapter((Resource)adaptable, type);
        }
        if (adaptable instanceof ResourceResolver) {
            return this.getAdapter((ResourceResolver)adaptable, type);
        }
        return null;
    }

    @Nullable
    private <AdapterType> AdapterType getAdapter(@NotNull Resource resource, @NotNull Class<AdapterType> type) {
        if (type == Page.class && this.isPrimaryType(resource, "cq:Page")) {
            return (AdapterType)((Object)new MockPage(resource));
        }
        if (type == Template.class && this.isPrimaryType(resource, "cq:Template")) {
            return (AdapterType)((Object)new MockTemplate(resource));
        }
        if (type == Asset.class && DamUtil.isAsset((Resource)resource)) {
            return (AdapterType)((Object)new MockAsset(resource, this.eventAdmin));
        }
        if (type == Rendition.class && DamUtil.isRendition((Resource)resource)) {
            return (AdapterType)((Object)new MockRendition(resource));
        }
        if (type == Tag.class && this.isPrimaryType(resource, "cq:Tag")) {
            return (AdapterType)new MockTag(resource);
        }
        return null;
    }

    @Nullable
    private <AdapterType> AdapterType getAdapter(@NotNull ResourceResolver resolver, @NotNull Class<AdapterType> type) {
        if (type == PageManager.class) {
            return (AdapterType)((Object)new MockPageManager(resolver));
        }
        if (type == ComponentManager.class) {
            return (AdapterType)new MockComponentManager(resolver);
        }
        if (type == TagManager.class) {
            return (AdapterType)new MockTagManager(resolver);
        }
        if (type == Designer.class) {
            return (AdapterType)new MockDesigner();
        }
        if (type == AssetManager.class) {
            return (AdapterType)new MockAssetManager(resolver, this.eventAdmin);
        }
        return null;
    }

    private boolean isPrimaryType(@NotNull Resource resource, String primaryType) {
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            try {
                return StringUtils.equals((CharSequence)node.getPrimaryNodeType().getName(), (CharSequence)primaryType);
            }
            catch (RepositoryException ex) {
                return false;
            }
        }
        ValueMap props = resource.getValueMap();
        return StringUtils.equals((CharSequence)((CharSequence)props.get("jcr:primaryType", String.class)), (CharSequence)primaryType);
    }
}

