/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.api.DamEvent;
import com.day.cq.dam.api.Revision;
import com.day.image.Layer;
import com.google.common.collect.ImmutableMap;
import io.wcm.testing.mock.aem.builder.ContentBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.testing.mock.sling.loader.ContentLoader;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.event.EventAdmin;

class MockAssetManager
implements AssetManager {
    private final ResourceResolver resourceResolver;
    private final ContentBuilder contentBuilder;
    private final ContentLoader contentLoader;
    private final EventAdmin eventAdmin;

    MockAssetManager(@NotNull ResourceResolver resourceResolver, EventAdmin eventAdmin) {
        this.resourceResolver = resourceResolver;
        this.contentBuilder = new ContentBuilder(resourceResolver);
        this.contentLoader = new ContentLoader(resourceResolver);
        this.eventAdmin = eventAdmin;
    }

    public Asset createAsset(String path, InputStream inputStream, String mimeType, boolean autoSave) {
        try {
            this.contentBuilder.resource(path, (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"dam:Asset").build());
            this.contentBuilder.resource(path + "/" + "jcr:content", (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"dam:AssetContent").build());
            String renditionsPath = path + "/" + "jcr:content" + "/" + "renditions";
            this.contentBuilder.resource(renditionsPath, (Map)ImmutableMap.builder().put((Object)"jcr:primaryType", (Object)"nt:folder").build());
            HashMap<String, Integer> metadataProps = new HashMap<String, Integer>();
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
                try {
                    Layer layer = new Layer((InputStream)is);
                    metadataProps.put("tiff:ImageWidth", layer.getWidth());
                    metadataProps.put("tiff:ImageLength", layer.getHeight());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.contentBuilder.resource(path + "/" + "jcr:content" + "/" + "metadata", metadataProps);
            is = new ByteArrayInputStream(data);
            var9_10 = null;
            try {
                this.contentLoader.binaryFile((InputStream)is, renditionsPath + "/" + "original", mimeType);
            }
            catch (Throwable throwable) {
                var9_10 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var9_10 != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable) {
                            var9_10.addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)is).close();
                    }
                }
            }
            if (autoSave) {
                this.resourceResolver.commit();
            }
            this.eventAdmin.sendEvent(DamEvent.assetCreated((String)path, (String)this.resourceResolver.getUserID()).toEvent());
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to create asset at " + path, ex);
        }
        return (Asset)this.resourceResolver.getResource(path).adaptTo(Asset.class);
    }

    public Asset restore(String s) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Collection<Revision> getRevisions(String s, Calendar calendar) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Asset createAssetForBinary(String s, boolean b) {
        throw new UnsupportedOperationException();
    }

    public Asset getAssetForBinary(String s) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAssetForBinary(String s) {
        throw new UnsupportedOperationException();
    }

    public Revision createRevision(Asset asset, String s, String s1) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String assignAssetID(Asset asset) throws PathNotFoundException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Asset createOrUpdateAsset(String arg0, Binary arg1, String arg2, boolean arg3) {
        throw new UnsupportedOperationException();
    }
}

