/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentEditConfig;
import com.day.cq.wcm.api.components.VirtualComponent;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;

class MockComponent
extends SlingAdaptable
implements Component {
    private final Resource resource;
    private final ValueMap props;
    private Component superComponent;
    private boolean superComponentInitialized;

    MockComponent(@NotNull Resource resource) {
        this.resource = resource;
        this.props = ResourceUtil.getValueMap((Resource)resource);
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public String getName() {
        return this.resource.getName();
    }

    public String getTitle() {
        return (String)this.props.get("jcr:title", String.class);
    }

    public String getDescription() {
        return (String)this.props.get("jcr:description", String.class);
    }

    public ValueMap getProperties() {
        return this.props;
    }

    public String getResourceType() {
        return this.resource.getResourceType();
    }

    public boolean isAccessible() {
        return true;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Resource.class) {
            return (AdapterType)this.resource;
        }
        return (AdapterType)super.adaptTo(type);
    }

    public String getComponentGroup() {
        return (String)this.props.get("componentGroup", String.class);
    }

    public boolean noDecoration() {
        return (Boolean)this.props.get("cq:noDecoration", (Object)false);
    }

    public Map<String, String> getHtmlTagAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        Resource htmlTagChild = this.resource.getChild("cq:htmlTag");
        if (htmlTagChild != null) {
            ValueMap htmlTagProps = htmlTagChild.getValueMap();
            Set keySet = htmlTagProps.keySet();
            for (String key : keySet) {
                String value = (String)htmlTagProps.get(key, String.class);
                if (value == null) continue;
                attrs.put(key, value);
            }
        }
        return ImmutableMap.copyOf(attrs);
    }

    public Component getSuperComponent() {
        if (!this.superComponentInitialized) {
            Resource superResource;
            String resourceSuperType = this.resource.getResourceSuperType();
            if (StringUtils.isNotEmpty((CharSequence)resourceSuperType) && (superResource = this.resource.getResourceResolver().getResource(resourceSuperType)) != null) {
                this.superComponent = new MockComponent(superResource);
            }
            this.superComponentInitialized = true;
        }
        return this.superComponent;
    }

    public String getCellName() {
        throw new UnsupportedOperationException();
    }

    public boolean isEditable() {
        throw new UnsupportedOperationException();
    }

    public boolean isDesignable() {
        throw new UnsupportedOperationException();
    }

    public boolean isContainer() {
        throw new UnsupportedOperationException();
    }

    public boolean isAnalyzable() {
        throw new UnsupportedOperationException();
    }

    public String getDialogPath() {
        throw new UnsupportedOperationException();
    }

    public String getDesignDialogPath() {
        throw new UnsupportedOperationException();
    }

    public String getIconPath() {
        throw new UnsupportedOperationException();
    }

    public String getThumbnailPath() {
        throw new UnsupportedOperationException();
    }

    public ComponentEditConfig getDeclaredEditConfig() {
        throw new UnsupportedOperationException();
    }

    public ComponentEditConfig getDeclaredChildEditConfig() {
        throw new UnsupportedOperationException();
    }

    public ComponentEditConfig getEditConfig() {
        throw new UnsupportedOperationException();
    }

    public ComponentEditConfig getChildEditConfig() {
        throw new UnsupportedOperationException();
    }

    public ComponentEditConfig getDesignEditConfig(String cellName) {
        throw new UnsupportedOperationException();
    }

    public Resource getLocalResource(String name) {
        throw new UnsupportedOperationException();
    }

    public Collection<VirtualComponent> getVirtualComponents() {
        throw new UnsupportedOperationException();
    }

    public String getDefaultView() {
        throw new UnsupportedOperationException();
    }

    public String getTemplatePath() {
        throw new UnsupportedOperationException();
    }

    public String[] getInfoProviders() {
        throw new UnsupportedOperationException();
    }
}

