/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.api.DamEvent;
import com.day.cq.dam.api.Revision;
import com.day.image.Layer;
import io.wcm.testing.mock.aem.builder.ContentBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.testing.mock.sling.loader.ContentLoader;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.event.EventAdmin;

class MockAssetManager
implements AssetManager {
    private final ResourceResolver resourceResolver;
    private final ContentBuilder contentBuilder;
    private final ContentLoader contentLoader;
    private final EventAdmin eventAdmin;

    MockAssetManager(@NotNull ResourceResolver resourceResolver, EventAdmin eventAdmin) {
        this.resourceResolver = resourceResolver;
        this.contentBuilder = new ContentBuilder(resourceResolver);
        this.contentLoader = new ContentLoader(resourceResolver);
        this.eventAdmin = eventAdmin;
    }

    public Asset createAsset(String assetPath, InputStream inputStream, String mimeType, boolean autoSave) {
        String assetContentPath = assetPath + "/" + "jcr:content";
        String metadataPath = assetContentPath + "/" + "metadata";
        String renditionsPath = assetContentPath + "/" + "renditions";
        try {
            Throwable throwable;
            ByteArrayInputStream is;
            byte[] data;
            this.createOrUpdateResource(assetPath, "dam:Asset", null);
            this.createOrUpdateResource(assetContentPath, "dam:AssetContent", null);
            this.createOrUpdateResource(renditionsPath, "nt:folder", null);
            HashMap<String, Object> metadataProps = new HashMap<String, Object>();
            byte[] byArray = data = inputStream != null ? IOUtils.toByteArray((InputStream)inputStream) : null;
            if (data != null) {
                is = new ByteArrayInputStream(data);
                throwable = null;
                try {
                    try {
                        Layer layer = new Layer((InputStream)is);
                        metadataProps.put("tiff:ImageWidth", layer.getWidth());
                        metadataProps.put("tiff:ImageLength", layer.getHeight());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((InputStream)is).close();
                        }
                    }
                }
            }
            this.createOrUpdateResource(metadataPath, "nt:unstructured", metadataProps);
            if (data != null) {
                is = new ByteArrayInputStream(data);
                throwable = null;
                try {
                    this.contentLoader.binaryFile((InputStream)is, renditionsPath + "/" + "original", mimeType);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ((InputStream)is).close();
                        }
                    }
                }
            }
            if (autoSave) {
                this.resourceResolver.commit();
            }
            this.eventAdmin.sendEvent(DamEvent.assetCreated((String)assetPath, (String)this.resourceResolver.getUserID()).toEvent());
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to create asset at " + assetPath, ex);
        }
        return (Asset)this.resourceResolver.getResource(assetPath).adaptTo(Asset.class);
    }

    private void createOrUpdateResource(String path, String jcrPrimaryType, Map<String, Object> props) {
        Resource resource = this.resourceResolver.getResource(path);
        if (resource == null) {
            HashMap<String, Object> newResourceProps = new HashMap<String, Object>();
            newResourceProps.put("jcr:primaryType", jcrPrimaryType);
            if (props != null) {
                newResourceProps.putAll(props);
            }
            this.contentBuilder.resource(path, newResourceProps);
        } else if (props != null) {
            ModifiableValueMap existingResourceProps = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
            existingResourceProps.putAll(props);
        }
    }

    public Asset restore(String s) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Collection<Revision> getRevisions(String s, Calendar calendar) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Asset createAssetForBinary(String s, boolean b) {
        throw new UnsupportedOperationException();
    }

    public Asset getAssetForBinary(String s) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAssetForBinary(String s) {
        throw new UnsupportedOperationException();
    }

    public Revision createRevision(Asset asset, String s, String s1) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String assignAssetID(Asset asset) throws PathNotFoundException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Asset createOrUpdateAsset(String arg0, Binary arg1, String arg2, boolean arg3) {
        throw new UnsupportedOperationException();
    }
}

