/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.granite;

import com.adobe.granite.workflow.collection.ResourceCollection;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;

class MockResourceCollection
implements ResourceCollection {
    private final String packagePath;
    private final WorkspaceFilter packageFilter;
    private final Session session;

    MockResourceCollection(String packagePath, WorkspaceFilter packageFilter, Session session) {
        this.packagePath = packagePath;
        this.packageFilter = packageFilter;
        this.session = session;
    }

    public List<Node> list(String[] allowedNodesTypes) throws RepositoryException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        FilterPathCollector filterPathCollector = new FilterPathCollector();
        if (this.packageFilter.getFilterSets().size() == 1) {
            String filterPath = ((PathFilterSet)this.packageFilter.getFilterSets().get(0)).getRoot();
            this.addNode(nodes, filterPath, allowedNodesTypes);
        } else {
            this.packageFilter.dumpCoverage(this.session, (ProgressTrackerListener)filterPathCollector, true);
            List<String> list = filterPathCollector.getPaths();
            for (String filterPath : list) {
                this.addNode(nodes, filterPath, allowedNodesTypes);
            }
        }
        return nodes;
    }

    public String getPath() {
        return this.packagePath;
    }

    private void addNode(List<Node> nodes, String path, String[] allowedNodeTypes) throws RepositoryException {
        Node node;
        if (this.session.nodeExists(path) && this.isAllowedNodeType(node = this.session.getNode(path), allowedNodeTypes)) {
            nodes.add(node);
        }
    }

    private boolean isAllowedNodeType(Node node, String[] allowedNodesTypes) throws RepositoryException {
        for (String nodeType : allowedNodesTypes) {
            if (!node.isNodeType(nodeType)) continue;
            return true;
        }
        return false;
    }

    public void remove(Node node) {
        throw new UnsupportedOperationException();
    }

    private static class FilterPathCollector
    implements ProgressTrackerListener {
        private final List<String> paths = new ArrayList<String>();

        private FilterPathCollector() {
        }

        public void onMessage(ProgressTrackerListener.Mode mode, String action, String path) {
            this.paths.add(path);
        }

        public void onError(ProgressTrackerListener.Mode mode, String string, Exception exception) {
        }

        public List<String> getPaths() {
            return this.paths;
        }
    }
}

