/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.dam;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import io.wcm.testing.mock.aem.dam.MockAsset;
import io.wcm.testing.mock.aem.dam.MockAssetManager;
import io.wcm.testing.mock.aem.dam.MockRendition;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;

@Component(service={AdapterFactory.class}, property={"adaptables=org.apache.sling.api.resource.Resource", "adaptables=org.apache.sling.api.resource.ResourceResolver", "adapters=com.day.cq.dam.api.Asset", "adapters=com.day.cq.dam.api.AssetManager", "adapters=com.day.cq.dam.api.Rendition"})
@ProviderType
public class MockAemDamAdapterFactory
implements AdapterFactory {
    @Reference
    private EventAdmin eventAdmin;

    @Nullable
    public <AdapterType> AdapterType getAdapter(@NotNull Object adaptable, @NotNull Class<AdapterType> type) {
        if (adaptable instanceof Resource) {
            return this.getAdapter((Resource)adaptable, type);
        }
        if (adaptable instanceof ResourceResolver) {
            return this.getAdapter((ResourceResolver)adaptable, type);
        }
        return null;
    }

    @Nullable
    private <AdapterType> AdapterType getAdapter(@NotNull Resource resource, @NotNull Class<AdapterType> type) {
        if (type == Asset.class && DamUtil.isAsset((Resource)resource)) {
            return (AdapterType)((Object)new MockAsset(resource, this.eventAdmin));
        }
        if (type == Rendition.class && DamUtil.isRendition((Resource)resource)) {
            return (AdapterType)((Object)new MockRendition(resource));
        }
        return null;
    }

    @Nullable
    private <AdapterType> AdapterType getAdapter(@NotNull ResourceResolver resolver, @NotNull Class<AdapterType> type) {
        if (type == AssetManager.class) {
            return (AdapterType)new MockAssetManager(resolver, this.eventAdmin);
        }
        return null;
    }
}

