/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.commons.Language;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.wcm.api.LanguageManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.text.Text;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.service.component.annotations.Component;

@Component(service={LanguageManager.class})
@ProviderType
public final class MockLanguageManager
implements LanguageManager {
    @Deprecated
    public Map<Locale, LanguageManager.Info> getAdjacentInfo(ResourceResolver resourceResolver, String path) {
        return Optional.ofNullable(this.getAdjacentLanguageInfo(resourceResolver, path)).map(Map::entrySet).map(Collection::stream).map(entries -> entries.collect(MockLanguageManager.toLinkedMap(i -> ((Language)i.getKey()).getLocale(), Map.Entry::getValue))).orElse(null);
    }

    public Map<Language, LanguageManager.Info> getAdjacentLanguageInfo(ResourceResolver resourceResolver, String path) {
        return Optional.ofNullable(LanguageUtil.getLanguageRoot((String)path)).map(root -> path.substring(root.length())).map(relPath -> relPath.startsWith("/") ? relPath.substring(1) : relPath).map(relPath -> this.getLanguageRootStream(resourceResolver, path).map(info -> ((InfoImpl)info).getChild(relPath, resourceResolver)).collect(MockLanguageManager.toLinkedMap(rec$ -> ((InfoImpl)rec$).getLanguage(), i -> i))).orElse(null);
    }

    public Locale getLanguage(Resource resource) {
        return this.getLanguage(resource, true);
    }

    public Language getCqLanguage(Resource resource) {
        return this.getCqLanguage(resource, true);
    }

    public Locale getLanguage(Resource resource, boolean respectContent) {
        return Optional.ofNullable(this.getCqLanguage(resource, respectContent)).map(Language::getLocale).orElse(null);
    }

    public Language getCqLanguage(Resource resource, boolean respectContent) {
        Optional<Page> page = Optional.ofNullable(resource.getResourceResolver().adaptTo(PageManager.class)).map(pm -> pm.getContainingPage(resource));
        if (respectContent) {
            return page.map(Page::getContentResource).map(HierarchyNodeInheritanceValueMap::new).map(vm -> (String)vm.getInherited("jcr:language", String.class)).map(LanguageUtil::getLanguage).orElseGet(() -> this.getCqLanguage(resource, false));
        }
        return page.map(Page::getPath).map(LanguageUtil::getLanguageRoot).map(Text::getName).map(Language::new).orElse(null);
    }

    public Page getLanguageRoot(Resource resource) {
        return Optional.ofNullable(LanguageUtil.getLanguageRoot((String)resource.getPath())).map(arg_0 -> ((ResourceResolver)resource.getResourceResolver()).getResource(arg_0)).map(res -> (Page)res.adaptTo(Page.class)).orElse(null);
    }

    public Collection<Locale> getLanguages(ResourceResolver resourceResolver, String path) {
        return this.getCqLanguages(resourceResolver, path).stream().map(Language::getLocale).collect(Collectors.toList());
    }

    public Collection<Language> getCqLanguages(ResourceResolver resourceResolver, String path) {
        return this.getLanguageRootStream(resourceResolver, path).map(rec$ -> ((InfoImpl)rec$).getLanguage()).collect(Collectors.toList());
    }

    public Collection<Page> getLanguageRoots(ResourceResolver resourceResolver, String path) {
        return this.getLanguageRootStream(resourceResolver, path).map(rec$ -> ((InfoImpl)rec$).getResource()).filter(Objects::nonNull).map(res -> (Page)res.adaptTo(Page.class)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Stream<InfoImpl> getLanguageRootStream(ResourceResolver resourceResolver, String path) {
        return Optional.ofNullable(LanguageUtil.getLanguageRoot((String)path)).map(arg_0 -> ((ResourceResolver)resourceResolver).getResource(arg_0)).map(Resource::getParent).map(Resource::listChildren).map(childIterator -> StreamSupport.stream(((Iterable)() -> childIterator).spliterator(), false)).orElseGet(Stream::empty).filter(res -> Objects.nonNull(LanguageUtil.getLanguage((String)res.getName()))).map(res -> new InfoImpl(res.getPath(), (Resource)res, LanguageUtil.getLanguage((String)res.getName())));
    }

    private static <T, K, U> Collector<T, ?, Map<K, U>> toLinkedMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new);
    }

    public String getIsoCountry(Locale locale) {
        throw new UnsupportedOperationException();
    }

    public LanguageManager.Tree compareLanguageTrees(ResourceResolver resourceResolver, String path) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Page getLanguageRoot(Resource res, boolean respectContent) {
        throw new UnsupportedOperationException();
    }

    public Resource getLanguageRootResource(Resource res) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Resource getLanguageRootResource(Resource res, boolean respectContent) {
        throw new UnsupportedOperationException();
    }

    public Collection<Resource> getLanguageRootResources(ResourceResolver resolver, String path) {
        throw new UnsupportedOperationException();
    }

    public Collection<Resource> getLanguageRootResources(ResourceResolver resolver, String path, boolean respectContent) {
        throw new UnsupportedOperationException();
    }

    private static final class InfoImpl
    implements LanguageManager.Info {
        private final String path;
        private final Resource resource;
        private final Language language;

        InfoImpl(@NotNull String path, @Nullable Resource resource, @NotNull Language language) {
            this.path = path;
            this.resource = resource;
            this.language = language;
        }

        public String getPath() {
            return this.path;
        }

        public boolean exists() {
            return this.resource != null;
        }

        public boolean hasContent() {
            return Optional.ofNullable(this.resource).map(res -> this.resource.getChild("jcr:content")).isPresent();
        }

        public long getLastModified() {
            return Optional.ofNullable(this.resource).map(res -> this.resource.getChild("jcr:content")).map(Resource::getValueMap).map(vm -> (Long)vm.get("jcr:lastModified", Long.class)).orElse(0L);
        }

        @Nullable
        private Resource getResource() {
            return this.resource;
        }

        @NotNull
        private Language getLanguage() {
            return this.language;
        }

        private InfoImpl getChild(@NotNull String relPath, @NotNull ResourceResolver resourceResolver) {
            if (relPath.isEmpty()) {
                return this;
            }
            String childPath = String.join((CharSequence)"/", this.path, relPath);
            Resource child = resourceResolver.getResource(childPath);
            return new InfoImpl(childPath, child, this.getLanguage());
        }
    }
}

