/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.adobe.cq.dam.cfm.ContentElement;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.ContentVariation;
import com.adobe.cq.dam.cfm.VariationDef;
import com.adobe.cq.dam.cfm.VariationTemplate;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import io.wcm.testing.mock.aem.MockContentFragment;
import io.wcm.testing.mock.aem.MockContentFragment_ContentVariation_Text;
import io.wcm.testing.mock.aem.MockContentFragment_Versionable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MockContentFragment_ContentElement_Text
extends MockContentFragment_Versionable
implements ContentElement {
    private final MockContentFragment contentFragment;
    private final Resource textElementResource;
    private final Asset asset;

    MockContentFragment_ContentElement_Text(MockContentFragment contentFragment, Resource textElementResource) {
        this.contentFragment = contentFragment;
        this.textElementResource = textElementResource;
        this.asset = contentFragment.getAsset();
    }

    @Nullable
    public <AdapterType> AdapterType adaptTo(@NotNull Class<AdapterType> type) {
        return this.contentFragment.adaptTo(type);
    }

    public String getName() {
        return this.textElementResource.getName();
    }

    public String getTitle() {
        return (String)this.textElementResource.getValueMap().get("jcr:title", (Object)this.getName());
    }

    public String getContent() {
        return MockContentFragment_ContentElement_Text.getContent(this.asset, this.getRenditionName());
    }

    public void setContent(String content, String contentType) throws ContentFragmentException {
        MockContentFragment_ContentElement_Text.setContent(this.asset, this.getRenditionName(), content, contentType);
    }

    public String getContentType() {
        return MockContentFragment_ContentElement_Text.getContentType(this.asset, this.getRenditionName());
    }

    static String getContent(Asset asset, String renditionName) {
        Rendition rendition = asset.getRendition(renditionName);
        if (rendition != null) {
            String string;
            block9: {
                InputStream is = rendition.getStream();
                try {
                    string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Unable to get content fragment text from " + rendition.getPath(), ex);
                    }
                }
                is.close();
            }
            return string;
        }
        return null;
    }

    static void setContent(Asset asset, String renditionName, String content, String contentType) throws ContentFragmentException {
        Rendition rendition = asset.getRendition(renditionName);
        if (rendition != null) {
            asset.removeRendition(rendition.getName());
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));){
            asset.addRendition(renditionName, (InputStream)is, contentType);
        }
        catch (IOException ex) {
            throw new ContentFragmentException("Unable to ass rendition.", (Throwable)ex);
        }
    }

    static String getContentType(Asset asset, String renditionName) {
        Rendition rendition = asset.getRendition(renditionName);
        if (rendition != null) {
            return rendition.getMimeType();
        }
        return null;
    }

    private String getRenditionName() {
        if (StringUtils.equals((CharSequence)this.textElementResource.getName(), (CharSequence)"main")) {
            return "original";
        }
        return this.textElementResource.getName();
    }

    public ContentVariation createVariation(VariationTemplate template) throws ContentFragmentException {
        VariationDef variationDef = (VariationDef)template;
        return new MockContentFragment_ContentVariation_Text(variationDef, this.asset);
    }

    public ContentVariation getVariation(String variationName) {
        return this.getVariationsStream().filter(variation -> StringUtils.equals((CharSequence)variation.getName(), (CharSequence)variationName)).findFirst().orElse(null);
    }

    public Iterator<ContentVariation> getVariations() {
        return this.getVariationsStream().iterator();
    }

    private Stream<ContentVariation> getVariationsStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.contentFragment.listAllVariations(), 16), false).map(def -> new MockContentFragment_ContentVariation_Text((VariationDef)def, this.asset));
    }

    public void removeVariation(ContentVariation variation) throws ContentFragmentException {
        Rendition rendition = this.asset.getRendition(variation.getName());
        if (rendition != null) {
            this.asset.removeRendition(rendition.getName());
        }
    }

    public ContentVariation getResolvedVariation(String variationName) {
        throw new UnsupportedOperationException();
    }
}

