/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.dam;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.api.DamEvent;
import com.day.cq.dam.api.Revision;
import com.day.image.Layer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.testing.mock.aem.builder.ContentBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.testing.mock.sling.loader.ContentLoader;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.EventAdmin;

class MockAssetManager
implements AssetManager {
    private final ResourceResolver resourceResolver;
    private final ContentBuilder contentBuilder;
    private final ContentLoader contentLoader;
    private final EventAdmin eventAdmin;

    MockAssetManager(@NotNull ResourceResolver resourceResolver, EventAdmin eventAdmin, BundleContext bundleContext) {
        this.resourceResolver = resourceResolver;
        this.contentBuilder = new ContentBuilder(resourceResolver);
        this.contentLoader = new ContentLoader(resourceResolver, bundleContext, false);
        this.eventAdmin = eventAdmin;
    }

    @SuppressFBWarnings(value={"BAD_PRACTICE", "STYLE"})
    public Asset createAsset(String assetPath, InputStream inputStream, String mimeType, boolean autoSave) {
        String assetContentPath = assetPath + "/" + "jcr:content";
        String metadataPath = assetContentPath + "/" + "metadata";
        String renditionsPath = assetContentPath + "/" + "renditions";
        try {
            byte[] data;
            this.createOrUpdateResource(assetPath, "dam:Asset", null);
            this.createOrUpdateResource(assetContentPath, "dam:AssetContent", null);
            this.createOrUpdateResource(renditionsPath, "nt:folder", null);
            HashMap<String, Object> metadataProps = new HashMap<String, Object>();
            byte[] byArray = data = inputStream != null ? IOUtils.toByteArray((InputStream)inputStream) : null;
            if (data != null) {
                try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
                    try {
                        Layer layer = new Layer((InputStream)is);
                        metadataProps.put("tiff:ImageWidth", layer.getWidth());
                        metadataProps.put("tiff:ImageLength", layer.getHeight());
                    }
                    catch (Exception layer) {
                        // empty catch block
                    }
                }
            }
            this.createOrUpdateResource(metadataPath, "nt:unstructured", metadataProps);
            String originalRenditionPath = renditionsPath + "/" + "original";
            if (data != null) {
                try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
                    this.contentLoader.binaryFile((InputStream)is, originalRenditionPath, mimeType);
                }
                this.eventAdmin.sendEvent(DamEvent.renditionUpdated((String)assetPath, (String)this.resourceResolver.getUserID(), (String)originalRenditionPath).toEvent());
            }
            if (autoSave) {
                this.resourceResolver.commit();
            }
            this.eventAdmin.sendEvent(DamEvent.assetCreated((String)assetPath, (String)this.resourceResolver.getUserID()).toEvent());
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to create asset at " + assetPath, ex);
        }
        return (Asset)this.resourceResolver.getResource(assetPath).adaptTo(Asset.class);
    }

    @SuppressFBWarnings(value={"STYLE"})
    private void createOrUpdateResource(String path, String jcrPrimaryType, Map<String, Object> props) {
        Resource resource = this.resourceResolver.getResource(path);
        if (resource == null) {
            HashMap<String, Object> newResourceProps = new HashMap<String, Object>();
            newResourceProps.put("jcr:primaryType", jcrPrimaryType);
            if (props != null) {
                newResourceProps.putAll(props);
            }
            this.contentBuilder.resource(path, newResourceProps);
        } else if (props != null) {
            ModifiableValueMap existingResourceProps = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
            existingResourceProps.putAll(props);
        }
    }

    public Asset restore(String s) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Collection<Revision> getRevisions(String s, Calendar calendar) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Asset createAssetForBinary(String s, boolean b) {
        throw new UnsupportedOperationException();
    }

    public Asset getAssetForBinary(String s) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAssetForBinary(String s) {
        throw new UnsupportedOperationException();
    }

    public Revision createRevision(Asset asset, String s, String s1) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String assignAssetID(Asset asset) throws PathNotFoundException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Asset createOrUpdateAsset(String arg0, Binary arg1, String arg2, boolean arg3) {
        throw new UnsupportedOperationException();
    }

    public Revision createRevision(Asset arg0, String arg1, String arg2, User arg3) {
        throw new UnsupportedOperationException();
    }

    public Asset createOrReplaceAsset(String arg0, Binary arg1, String arg2, boolean arg3) {
        throw new UnsupportedOperationException();
    }

    public Asset createOrUpdateAsset(String arg0, Binary arg1, String arg2, boolean arg3, boolean arg4, String arg5, String arg6) {
        throw new UnsupportedOperationException();
    }
}

