/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.builder;

import com.adobe.cq.dam.cfm.ContentFragment;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.api.DamEvent;
import com.day.cq.dam.api.Rendition;
import com.day.cq.tagging.InvalidTagFormatException;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import com.day.image.Layer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.testing.mock.aem.context.AemContextImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.sling.builder.ImmutableValueMap;
import org.apache.sling.testing.mock.sling.loader.ContentLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.service.event.EventAdmin;

@ProviderType
public final class ContentBuilder
extends org.apache.sling.testing.mock.sling.builder.ContentBuilder {
    @NotNull
    static final String DUMMY_TEMPLATE = "/apps/sample/templates/template1";
    private static final Map<String, byte[]> DUMMY_IMAGE_CACHE = new HashMap<String, byte[]>();
    @Nullable
    private final AemContextImpl context;

    public ContentBuilder(@NotNull ResourceResolver resourceResolver) {
        super(resourceResolver);
        this.context = null;
    }

    public ContentBuilder(@NotNull AemContextImpl context) {
        super(context.resourceResolver());
        this.context = context;
    }

    public Page page(@NotNull String path) {
        return this.page(path, DUMMY_TEMPLATE, (Map<String, Object>)ValueMap.EMPTY);
    }

    public Page page(@NotNull String path, @Nullable String template) {
        return this.page(path, template, (Map<String, Object>)ValueMap.EMPTY);
    }

    public Page page(@NotNull String path, @Nullable String template, @NotNull String title) {
        return this.page(path, template, (Map<String, Object>)ImmutableValueMap.of((String)"jcr:title", (Object)title));
    }

    public Page page(@NotNull String path, @Nullable String template, @NotNull Map<String, Object> pageProperties) {
        String parentPath = ResourceUtil.getParent((String)path);
        if (parentPath == null) {
            throw new IllegalArgumentException("Resource has no parent: " + path);
        }
        this.ensureResourceExists(parentPath);
        String name = ResourceUtil.getName((String)path);
        try {
            PageManager pageManager = (PageManager)this.resourceResolver.adaptTo(PageManager.class);
            if (pageManager == null) {
                throw new RuntimeException("No page manager.");
            }
            Page page = pageManager.create(parentPath, name, template, name, true);
            if (!pageProperties.isEmpty()) {
                ModifiableValueMap props = (ModifiableValueMap)page.getContentResource().adaptTo(ModifiableValueMap.class);
                if (props == null) {
                    throw new RuntimeException("No ModifiableValueMap.");
                }
                props.putAll(pageProperties);
                this.resourceResolver.commit();
            }
            return page;
        }
        catch (WCMException | PersistenceException ex) {
            throw new RuntimeException("Unable to create page at " + path, ex);
        }
    }

    public Page page(@NotNull String path, @Nullable String template, Object ... pageProperties) {
        return this.page(path, template, MapUtil.toMap((Object[])pageProperties));
    }

    public Page page(@NotNull Page parentPage, @NotNull String name) {
        return this.page(parentPage, name, DUMMY_TEMPLATE, (Map<String, Object>)ValueMap.EMPTY);
    }

    public Page page(@NotNull Page parentPage, @NotNull String name, @Nullable String template) {
        return this.page(parentPage, name, template, (Map<String, Object>)ValueMap.EMPTY);
    }

    public Page page(@NotNull Page parentPage, @NotNull String name, @Nullable String template, @NotNull String title) {
        return this.page(parentPage, name, template, (Map<String, Object>)ImmutableValueMap.of((String)"jcr:title", (Object)title));
    }

    public Page page(@NotNull Page parentPage, @NotNull String name, @Nullable String template, @NotNull Map<String, Object> pageProperties) {
        String path = parentPage.getPath() + "/" + StringUtils.stripStart((String)name, (String)"/");
        return this.page(path, template, pageProperties);
    }

    public Page page(@NotNull Page parentPage, @NotNull String name, @Nullable String template, Object ... pageProperties) {
        return this.page(parentPage, name, template, MapUtil.toMap((Object[])pageProperties));
    }

    public Asset asset(@NotNull String path, @NotNull String classpathResource, @NotNull String mimeType) {
        return this.asset(path, classpathResource, mimeType, (Map<String, Object>)null);
    }

    public Asset asset(@NotNull String path, @NotNull String classpathResource, @NotNull String mimeType, @Nullable Map<String, Object> metadata) {
        Asset asset;
        block9: {
            InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
            try {
                if (is == null) {
                    throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
                }
                asset = this.asset(path, is, mimeType, metadata);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            is.close();
        }
        return asset;
    }

    public Asset asset(@NotNull String path, @NotNull String classpathResource, @NotNull String mimeType, Object ... metadata) {
        return this.asset(path, classpathResource, mimeType, (Map<String, Object>)MapUtil.toMap((Object[])metadata));
    }

    public Asset asset(@NotNull String path, long width, long height, @NotNull String mimeType) {
        return this.asset(path, width, height, mimeType, null);
    }

    public Asset asset(@NotNull String path, long width, long height, @NotNull String mimeType, @Nullable Map<String, Object> metadata) {
        Asset asset;
        block8: {
            InputStream is = ContentBuilder.createDummyImage(width, height, mimeType);
            try {
                asset = this.asset(path, is, mimeType, metadata);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            is.close();
        }
        return asset;
    }

    public Asset asset(@NotNull String path, long width, long height, @NotNull String mimeType, Object ... metadata) {
        return this.asset(path, width, height, mimeType, MapUtil.toMap((Object[])metadata));
    }

    public Asset asset(@NotNull String path, @NotNull InputStream inputStream, @NotNull String mimeType) {
        return this.asset(path, inputStream, mimeType, (Map<String, Object>)null);
    }

    public Asset asset(@NotNull String path, @NotNull InputStream inputStream, @NotNull String mimeType, @Nullable Map<String, Object> metadata) {
        AssetManager assetManager = (AssetManager)this.resourceResolver.adaptTo(AssetManager.class);
        if (assetManager == null) {
            throw new RuntimeException("No asset manager.");
        }
        Asset asset = assetManager.createAsset(path, inputStream, mimeType, true);
        if (metadata != null && !metadata.isEmpty()) {
            ModifiableValueMap metadataProperties;
            String metadataPath = asset.getPath() + "/" + "jcr:content" + "/" + "metadata";
            Resource metadataResource = this.resourceResolver.getResource(metadataPath);
            if (metadataResource == null) {
                metadataResource = this.resource(metadataPath);
            }
            if ((metadataProperties = (ModifiableValueMap)metadataResource.adaptTo(ModifiableValueMap.class)) == null) {
                throw new RuntimeException("No ModifiableValueMap.");
            }
            metadataProperties.putAll(metadata);
        }
        return asset;
    }

    public Asset asset(@NotNull String path, @NotNull InputStream inputStream, @NotNull String mimeType, Object ... metadata) {
        return this.asset(path, inputStream, mimeType, (Map<String, Object>)MapUtil.toMap((Object[])metadata));
    }

    @NotNull
    public static InputStream createDummyImage(long width, long height, String mimeType) {
        String key = width + "x" + height + ":" + mimeType;
        byte[] data = DUMMY_IMAGE_CACHE.get(key);
        if (data == null) {
            Layer layer = new Layer((int)width, (int)height, null);
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                double quality = StringUtils.equals((CharSequence)mimeType, (CharSequence)"image/gif") ? 256.0 : 1.0;
                layer.write(mimeType, quality, (OutputStream)bos);
                data = bos.toByteArray();
                DUMMY_IMAGE_CACHE.put(key, data);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return new ByteArrayInputStream(data);
    }

    public Rendition assetRendition(@NotNull Asset asset, @NotNull String name, @NotNull String classpathResource, @NotNull String mimeType) {
        Rendition rendition;
        block9: {
            InputStream is = ContentLoader.class.getResourceAsStream(classpathResource);
            try {
                if (is == null) {
                    throw new IllegalArgumentException("Classpath resource not found: " + classpathResource);
                }
                rendition = this.assetRendition(asset, name, is, mimeType);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            is.close();
        }
        return rendition;
    }

    public Rendition assetRendition(@NotNull Asset asset, @NotNull String name, long width, long height, @NotNull String mimeType) {
        Rendition rendition;
        block8: {
            InputStream is = ContentBuilder.createDummyImage(width, height, mimeType);
            try {
                rendition = this.assetRendition(asset, name, is, mimeType);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            is.close();
        }
        return rendition;
    }

    public Rendition assetRendition(@NotNull Asset asset, String name, @NotNull InputStream inputStream, @NotNull String mimeType) {
        return asset.addRendition(name, inputStream, mimeType);
    }

    public Rendition assetRenditionWebEnabled(@NotNull Asset asset) {
        return this.assetRenditionWebEnabled(asset, 1280L, 1280L);
    }

    public Rendition assetRenditionWebEnabled(@NotNull Asset asset, long maxWidth, long maxHeight) {
        int originalWidth = Integer.parseInt(StringUtils.defaultString((String)asset.getMetadataValueFromJcr("tiff:ImageWidth"), (String)"0"));
        int originalHeight = Integer.parseInt(StringUtils.defaultString((String)asset.getMetadataValueFromJcr("tiff:ImageLength"), (String)"0"));
        if (originalWidth == 0 || originalHeight == 0) {
            throw new IllegalArgumentException("Asset has no valid width/height: " + asset.getPath());
        }
        String renditionName = "cq5dam.web." + maxWidth + "." + maxHeight + ".jpg";
        long width = (long)originalWidth > maxWidth ? maxWidth : (long)originalWidth;
        long height = (long)originalHeight > maxHeight ? maxHeight : (long)originalHeight;
        return this.assetRendition(asset, renditionName, width, height, "image/jpeg");
    }

    public ContentFragment contentFragmentStructured(@NotNull String path, @Nullable Map<String, Object> data) {
        return this.contentFragmentTextOrStructured(path, null, null, data);
    }

    public ContentFragment contentFragmentStructured(@NotNull String path, Object ... data) {
        return this.contentFragmentStructured(path, MapUtil.toMap((Object[])data));
    }

    public ContentFragment contentFragmentText(@NotNull String path, @NotNull String text, @NotNull String mimeType) {
        return this.contentFragmentTextOrStructured(path, text, mimeType, null);
    }

    @SuppressFBWarnings(value={"STYLE"})
    private ContentFragment contentFragmentTextOrStructured(@NotNull String path, @Nullable String text, @Nullable String mimeType, @Nullable Map<String, Object> data) {
        EventAdmin eventAdmin;
        this.resource(path, new Object[]{"jcr:primaryType", "dam:Asset"});
        this.resource(path + "/" + "jcr:content", new Object[]{"jcr:primaryType", "dam:AssetContent"});
        String renditionsPath = path + "/" + "jcr:content" + "/" + "renditions";
        this.resource(renditionsPath, new Object[]{"jcr:primaryType", "nt:folder"});
        HashMap<String, String> metadataProps = new HashMap<String, String>();
        if (mimeType != null) {
            metadataProps.put("dc:format", mimeType);
        }
        this.resource(path + "/" + "jcr:content" + "/" + "metadata", metadataProps);
        if (text != null) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));){
                ContentLoader contentLoader = new ContentLoader(this.resourceResolver);
                contentLoader.binaryFile((InputStream)is, renditionsPath + "/" + "original", mimeType);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to create content fragment at " + path, ex);
            }
            this.resource(path + "/" + "jcr:content" + "/model/elements/main", new Object[]{"name", "main", "jcr:title", "Main"});
        }
        if (data != null) {
            this.resource(path + "/" + "jcr:content" + "/data/master", data);
        }
        if (this.context != null && (eventAdmin = (EventAdmin)this.context.getService(EventAdmin.class)) != null) {
            eventAdmin.sendEvent(DamEvent.assetCreated((String)path, (String)this.resourceResolver.getUserID()).toEvent());
        }
        return (ContentFragment)this.resourceResolver.getResource(path).adaptTo(ContentFragment.class);
    }

    public Tag tag(@NotNull String tagId) {
        TagManager tagManager = (TagManager)this.resourceResolver.adaptTo(TagManager.class);
        if (tagManager == null) {
            throw new RuntimeException("No tag manager.");
        }
        String tagTitle = ResourceUtil.getName((String)StringUtils.substringAfter((String)tagId, (String)":"));
        try {
            return tagManager.createTag(tagId, tagTitle, null, true);
        }
        catch (InvalidTagFormatException | AccessControlException ex) {
            throw new RuntimeException("Unable to create tag: " + tagId, ex);
        }
    }

    @NotNull
    public Resource resource(@NotNull Page page, @NotNull String name) {
        return this.resource(page, name, (Map<String, Object>)ValueMap.EMPTY);
    }

    @NotNull
    public Resource resource(@NotNull Page page, @NotNull String name, @NotNull Map<String, Object> properties) {
        String path = page.getContentResource().getPath() + "/" + StringUtils.stripStart((String)name, (String)"/");
        return this.resource(path, properties);
    }

    @NotNull
    public Resource resource(@NotNull Page page, @NotNull String name, Object ... properties) {
        return this.resource(page, name, MapUtil.toMap((Object[])properties));
    }
}

