/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.commons.Filter;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagConstants;
import com.day.cq.tagging.TagManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.testing.mock.aem.MockTagManager;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.function.BinaryOperator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;

class MockTag
extends SlingAdaptable
implements Tag,
Comparable<Tag> {
    private final Resource resource;

    MockTag(@NotNull Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("resource is null");
        }
        if (!resource.getPath().startsWith(MockTagManager.getTagRootPath() + "/")) {
            throw new IllegalArgumentException("Tags should exist under " + MockTagManager.getTagRootPath());
        }
        this.resource = resource;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)o;
        Resource tagResource = (Resource)tag.adaptTo(Resource.class);
        return tagResource != null && StringUtils.equals((CharSequence)this.resource.getPath(), (CharSequence)tagResource.getPath());
    }

    public int hashCode() {
        return this.resource.getPath().hashCode();
    }

    @Override
    public int compareTo(Tag tag) {
        Resource tagResource = (Resource)tag.adaptTo(Resource.class);
        if (tagResource != null) {
            return this.resource.getPath().compareTo(tagResource.getPath());
        }
        return -1;
    }

    public String toString() {
        StringBuilder string = new StringBuilder().append("Tag [").append("path=").append(this.getPath()).append(", title=").append(this.getTitle()).append(", desc=").append(this.getDescription()).append("]");
        return string.toString();
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Resource.class) {
            return (AdapterType)this.resource;
        }
        Object result = super.adaptTo(type);
        if (result == null) {
            result = this.resource.adaptTo(type);
        }
        return (AdapterType)result;
    }

    @SuppressFBWarnings(value={"STYLE"})
    public Iterator<Resource> find() {
        TagManager tagManager = (TagManager)this.resource.getResourceResolver().adaptTo(TagManager.class);
        return tagManager.find(this.getPath());
    }

    @SuppressFBWarnings(value={"STYLE"})
    public long getCount() {
        TagManager tagManager = (TagManager)this.resource.getResourceResolver().adaptTo(TagManager.class);
        return tagManager.find(this.getPath()).getSize();
    }

    public String getDescription() {
        return (String)this.resource.getValueMap().get("jcr:description", String.class);
    }

    public long getLastModified() {
        Calendar lastMod = (Calendar)this.resource.getValueMap().get("jcr:lastModified", Calendar.class);
        if (lastMod == null) {
            return 0L;
        }
        return lastMod.getTimeInMillis();
    }

    public String getLastModifiedBy() {
        return (String)this.resource.getValueMap().get("jcr:lastModifiedBy", String.class);
    }

    public String getLocalTagID() {
        if (this.isNamespace()) {
            return "";
        }
        String tagID = this.getTagID();
        tagID = tagID.substring(tagID.indexOf(TagConstants.NAMESPACE_DELIMITER) + 1);
        return tagID;
    }

    public String getLocalizedTitle(Locale locale) {
        Object localeStr;
        if (locale == null) {
            return null;
        }
        ValueMap properties = this.resource.getValueMap();
        String title = (String)properties.get(StringUtils.lowerCase((String)("jcr:title." + (String)(localeStr = locale.getLanguage() + "_" + locale.getCountry()))), String.class);
        if (title == null) {
            localeStr = locale.getLanguage();
            title = (String)properties.get(StringUtils.lowerCase((String)("jcr:title." + (String)localeStr)), String.class);
        }
        return MockTag.escapeTitle(title);
    }

    public Map<Locale, String> getLocalizedTitles() {
        ValueMap properties = this.resource.getValueMap();
        HashMap<Locale, String> localeTitles = new HashMap<Locale, String>();
        for (Map.Entry propEntry : properties.entrySet()) {
            String propName = (String)propEntry.getKey();
            if (!propName.startsWith("jcr:title.")) continue;
            String localeName = propName.substring("jcr:title".length() + 1);
            Locale locale = LanguageUtil.getLocale((String)localeName);
            localeTitles.put(locale, propEntry.getValue().toString());
        }
        return localeTitles;
    }

    public String getName() {
        return this.resource.getName();
    }

    public Tag getNamespace() {
        if (this.isNamespace()) {
            return this;
        }
        MockTag namespace = this;
        while (!namespace.isNamespace()) {
            namespace = namespace.getParent();
        }
        return namespace;
    }

    @SuppressFBWarnings(value={"STYLE"})
    public Tag getParent() {
        if (this.isNamespace()) {
            return null;
        }
        return (Tag)this.resource.getParent().adaptTo(Tag.class);
    }

    public String getPath() {
        return this.resource.getPath();
    }

    @SuppressFBWarnings(value={"STYLE"})
    public String getTagID() {
        StringBuilder tagID = new StringBuilder(this.resource.getPath().length());
        MockTag tag = this;
        while (!tag.isNamespace()) {
            Resource tagResource = (Resource)tag.adaptTo(Resource.class);
            if (tagID.length() != 0) {
                tagID.insert(0, "/");
            }
            tagID.insert(0, tagResource.getName());
            tag = tag.getParent();
        }
        tagID.insert(0, TagConstants.NAMESPACE_DELIMITER);
        tagID.insert(0, ((Resource)tag.adaptTo(Resource.class)).getName());
        return tagID.toString();
    }

    public String getTitle() {
        String title = (String)this.resource.getValueMap().get("jcr:title", (Object)this.getName());
        return MockTag.escapeTitle(title);
    }

    public String getTitle(Locale locale) {
        String title = this.getLocalizedTitle(locale);
        if (title == null) {
            title = this.getTitle();
        }
        return title;
    }

    @SuppressFBWarnings(value={"STYLE"})
    public boolean isNamespace() {
        return MockTagManager.getTagRootPath().equals(this.resource.getParent().getPath());
    }

    public Iterator<Tag> listAllSubTags() {
        return this.listChildren(null, true);
    }

    public Iterator<Tag> listChildren() {
        return this.listChildren(null, false);
    }

    private Iterator<Tag> listChildren(Filter<Tag> filter, boolean recurse) {
        LinkedList<Tag> tags = new LinkedList<Tag>();
        LinkedList resources = new LinkedList();
        CollectionUtils.addAll(resources, (Iterator)this.resource.listChildren());
        while (!resources.isEmpty()) {
            Tag tag;
            Resource tagResource = (Resource)resources.poll();
            if (recurse) {
                CollectionUtils.addAll(resources, (Iterator)tagResource.listChildren());
            }
            if ((tag = (Tag)tagResource.adaptTo(Tag.class)) == null || filter != null && !filter.includes((Object)tag)) continue;
            tags.add(tag);
        }
        return tags.iterator();
    }

    public Iterator<Tag> listChildren(Filter<Tag> filter) {
        return this.listChildren(filter, false);
    }

    public String getXPathSearchExpression(String property) {
        String tagRoot = MockTagManager.getTagRootPath();
        String ns = this.getNamespace().getName();
        String relPath = StringUtils.substringAfter((String)this.getPath(), (String)(tagRoot + "/" + ns + "/"));
        String propertyName = this.extractPathPart(property, StringUtils::substringAfterLast, property);
        String propertyPath = this.extractPathPart(property, StringUtils::substringBeforeLast, "");
        String xpathProperty = (String)(StringUtils.isEmpty((CharSequence)propertyPath) ? "" : ISO9075.encodePath((String)propertyPath) + "/") + "@" + ISO9075.encode((String)propertyName);
        String xpathNamespace = "default".equals(ns) ? relPath : ns + ":" + relPath;
        return "(" + xpathProperty + "='" + xpathNamespace + "' or " + xpathProperty + "='" + tagRoot + "/" + ns + "/" + relPath + "' or jcr:like(" + xpathProperty + ", '" + xpathNamespace + "/%') or jcr:like(" + xpathProperty + ", '" + tagRoot + "/" + ns + "/" + relPath + "/%'))";
    }

    private static String escapeTitle(String title) {
        return StringUtils.replace((String)StringUtils.replace((String)title, (String)"/", (String)" "), (String)TagConstants.NAMESPACE_DELIMITER, (String)" ");
    }

    public String getTitlePath() {
        return this.getTitlePath(null);
    }

    public String getTitlePath(Locale locale) {
        StringBuilder titlePath = new StringBuilder();
        MockTag ancestor = this;
        while (ancestor != null) {
            String title;
            Tag parent = ancestor.getParent();
            if (ancestor != this) {
                if (parent == null) {
                    if ("default".equals(ancestor.getName())) break;
                    titlePath.insert(0, " : ");
                } else {
                    titlePath.insert(0, " / ");
                }
            }
            if ((title = ancestor.getTitle()) != null) {
                titlePath.insert(0, title);
            } else {
                titlePath.insert(0, ancestor.getName());
            }
            ancestor = parent;
        }
        return titlePath.toString();
    }

    public String getGQLSearchExpression(String arg0) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public Map<Locale, String> getLocalizedTitlePaths() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    private String extractPathPart(String property, BinaryOperator<String> pathPartExtractor, String defaultValue) {
        return StringUtils.removeStart((String)(StringUtils.contains((CharSequence)property, (CharSequence)String.valueOf('/')) ? (String)pathPartExtractor.apply(property, String.valueOf('/')) : defaultValue), (String)String.valueOf('@'));
    }
}

