/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.adobe.cq.dam.cfm.ContentElement;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.ElementTemplate;
import com.adobe.cq.dam.cfm.FragmentTemplate;
import com.adobe.cq.dam.cfm.VariationDef;
import com.adobe.cq.dam.cfm.VariationTemplate;
import com.day.cq.dam.api.Asset;
import com.day.cq.tagging.Tag;
import io.wcm.testing.mock.aem.MockContentFragment_ContentElement_Structured;
import io.wcm.testing.mock.aem.MockContentFragment_ContentElement_Text;
import io.wcm.testing.mock.aem.MockContentFragment_VariationDef;
import io.wcm.testing.mock.aem.MockContentFragment_Versionable;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.testing.mock.sling.builder.ImmutableValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MockContentFragment
extends MockContentFragment_Versionable
implements ContentFragment {
    private final Resource assetResource;
    private final Asset asset;
    private final Resource contentResource;
    private final ModifiableValueMap contentProps;
    private final ModifiableValueMap metadataProps;
    private final ModifiableValueMap structuredDataProps;
    private final Resource modelElementsResource;

    MockContentFragment(Resource assetResource) {
        this.assetResource = assetResource;
        this.asset = (Asset)assetResource.adaptTo(Asset.class);
        this.contentResource = assetResource.getChild("jcr:content");
        if (this.contentResource == null) {
            throw new IllegalArgumentException("Missing jcr:content node.");
        }
        this.contentProps = (ModifiableValueMap)this.contentResource.adaptTo(ModifiableValueMap.class);
        Resource metadataResource = this.contentResource.getChild("metadata");
        if (metadataResource == null) {
            throw new IllegalArgumentException("Missing jcr:content/metadata node.");
        }
        this.metadataProps = (ModifiableValueMap)metadataResource.adaptTo(ModifiableValueMap.class);
        Resource structuredDataResource = this.contentResource.getChild("data/master");
        this.structuredDataProps = structuredDataResource != null ? (ModifiableValueMap)structuredDataResource.adaptTo(ModifiableValueMap.class) : null;
        this.modelElementsResource = this.contentResource.getChild("model/elements");
    }

    public String getName() {
        return this.assetResource.getName();
    }

    public String getTitle() {
        return (String)this.contentProps.get("jcr:title", (Object)this.assetResource.getName());
    }

    public String getDescription() {
        return (String)this.contentProps.get("jcr:description", (Object)"");
    }

    public Map<String, Object> getMetaData() {
        return this.metadataProps;
    }

    public void setTitle(String title) throws ContentFragmentException {
        this.contentProps.put((Object)"jcr:title", (Object)title);
    }

    public void setDescription(String description) throws ContentFragmentException {
        this.contentProps.put((Object)"jcr:description", (Object)description);
    }

    public void setMetaData(String name, Object value) throws ContentFragmentException {
        this.metadataProps.put((Object)name, value);
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Resource.class) {
            return (AdapterType)this.assetResource;
        }
        if (type == Asset.class) {
            return (AdapterType)this.assetResource.adaptTo(Asset.class);
        }
        return null;
    }

    public Iterator<ContentElement> getElements() {
        if (this.structuredDataProps != null) {
            return this.structuredDataProps.keySet().stream().map(key -> new MockContentFragment_ContentElement_Structured(this, (String)key, this.structuredDataProps)).iterator();
        }
        if (this.modelElementsResource != null) {
            return StreamSupport.stream(this.modelElementsResource.getChildren().spliterator(), false).map(resource -> new MockContentFragment_ContentElement_Text(this, (Resource)resource)).iterator();
        }
        return Collections.emptyIterator();
    }

    public ContentElement getElement(String elementName) {
        if (this.structuredDataProps != null) {
            if (this.structuredDataProps.containsKey((Object)elementName)) {
                return new MockContentFragment_ContentElement_Structured(this, elementName, this.structuredDataProps);
            }
        } else if (this.modelElementsResource != null) {
            Resource resource = null;
            if (StringUtils.isEmpty((CharSequence)elementName)) {
                resource = this.modelElementsResource.getChild("main");
                if (resource == null) {
                    resource = this.modelElementsResource.getChild("master");
                }
            } else {
                resource = this.modelElementsResource.getChild(elementName);
            }
            if (resource != null) {
                return new MockContentFragment_ContentElement_Text(this, resource);
            }
        }
        return null;
    }

    public boolean hasElement(String elementName) {
        if (this.structuredDataProps != null) {
            return this.structuredDataProps.containsKey((Object)elementName);
        }
        if (this.modelElementsResource != null) {
            return this.modelElementsResource.getChild(elementName) != null;
        }
        return false;
    }

    Asset getAsset() {
        return this.asset;
    }

    Resource getContentResource() {
        return this.contentResource;
    }

    public VariationTemplate createVariation(String name, String title, String description) throws ContentFragmentException {
        ResourceResolver resourceResolver = this.contentResource.getResourceResolver();
        try {
            Resource variations = ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)(this.contentResource.getPath() + "/model/variations"), (String)"nt:unstructured", (String)"nt:unstructured", (boolean)false);
            if (variations.getChild(name) != null) {
                throw new ContentFragmentException("Variation " + name + " already exists.");
            }
            Resource child = resourceResolver.create(variations, name, (Map)ImmutableValueMap.of((String)"name", (Object)name, (String)"jcr:title", (Object)StringUtils.defaultString((String)title, (String)name), (String)"jcr:description", (Object)StringUtils.defaultString((String)description)));
            return new MockContentFragment_VariationDef(child);
        }
        catch (PersistenceException ex) {
            throw new ContentFragmentException("Unable to create variation: " + name, (Throwable)ex);
        }
    }

    public Iterator<VariationDef> listAllVariations() {
        Resource variations = this.contentResource.getChild("model/variations");
        if (variations == null) {
            return Collections.emptyIterator();
        }
        return StreamSupport.stream(variations.getChildren().spliterator(), false).map(resource -> new MockContentFragment_VariationDef((Resource)resource)).iterator();
    }

    public FragmentTemplate getTemplate() {
        throw new UnsupportedOperationException();
    }

    public ContentElement createElement(ElementTemplate template) throws ContentFragmentException {
        throw new UnsupportedOperationException();
    }

    public Iterator<Resource> getAssociatedContent() {
        throw new UnsupportedOperationException();
    }

    public void addAssociatedContent(Resource content) throws ContentFragmentException {
        throw new UnsupportedOperationException();
    }

    public void removeAssociatedContent(Resource content) throws ContentFragmentException {
        throw new UnsupportedOperationException();
    }

    public void removeVariation(String variation) throws ContentFragmentException {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Calendar getLastModifiedDate() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Calendar getLastModifiedDeep() throws ContentFragmentException {
        throw new UnsupportedOperationException();
    }

    public void setTags(@NotNull Tag[] tags) throws ContentFragmentException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Tag[] getTags() throws ContentFragmentException {
        throw new UnsupportedOperationException();
    }

    public void setVariationTags(@NotNull Tag[] tags, @NotNull String variationName) throws ContentFragmentException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Tag[] getVariationTags(@NotNull String variationName) throws ContentFragmentException {
        throw new UnsupportedOperationException();
    }
}

