/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.wcm.api.policies.ContentPolicyMapping;
import io.wcm.testing.mock.aem.builder.ContentBuilder;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.testing.mock.sling.builder.ImmutableValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MockContentPolicyStorage {
    static final String RT_CONTENTPOLICY = "wcm/core/components/policy/policy";
    static final String RT_CONTENT_POLICY_MAPPING = "wcm/core/components/policies/mapping";
    static final String RT_CONTENT_POLICY_MAPPINGS = "wcm/core/components/policies/mappings";
    static final String PN_POLICY = "cq:policy";
    static final String MOCK_POLICIES_PATH = "/conf/$aem-mock$/settings/wcm/policies";
    static final String MOCK_TEMPLATE_PATH = "/conf/$aem-mock$/settings/wcm/templates/$mock-template$";
    static final String MOCK_POLICY_NAME = "$mock-policy";

    private MockContentPolicyStorage() {
    }

    @NotNull
    public static ContentPolicyMapping storeContentPolicyMapping(@NotNull String resourceType, @NotNull Map<String, Object> properties, @NotNull ResourceResolver resourceResolver) {
        String relativeResourceType = MockContentPolicyStorage.makeResourceTypeRelative(resourceType);
        ContentBuilder builder = new ContentBuilder(resourceResolver);
        MockContentPolicyStorage.ensureMockTemplate(resourceResolver, builder);
        String relativePolicyPath = relativeResourceType + "/$mock-policy";
        String policyPath = "/conf/$aem-mock$/settings/wcm/policies/" + relativePolicyPath;
        MockContentPolicyStorage.storeResource(policyPath, properties, resourceResolver, builder);
        ImmutableValueMap policyMappingProperties = ImmutableValueMap.of((String)"sling:resourceType", (Object)RT_CONTENT_POLICY_MAPPING, (String)PN_POLICY, (Object)relativePolicyPath);
        String policyMappingPath = MockContentPolicyStorage.buildPolicyMappingPath(relativeResourceType);
        Resource mappingResource = MockContentPolicyStorage.storeResource(policyMappingPath, (Map<String, Object>)policyMappingProperties, resourceResolver, builder);
        ContentPolicyMapping mapping = (ContentPolicyMapping)mappingResource.adaptTo(ContentPolicyMapping.class);
        if (mapping == null) {
            throw new RuntimeException("Unable to map to ContentPolicyMapping.");
        }
        return mapping;
    }

    @Nullable
    public static ContentPolicyMapping getContentPolicyMapping(@NotNull String resourceType, @NotNull ResourceResolver resourceResolver) {
        String relativeResourceType = MockContentPolicyStorage.makeResourceTypeRelative(resourceType);
        String policyMappingPath = MockContentPolicyStorage.buildPolicyMappingPath(relativeResourceType);
        Resource resource = resourceResolver.getResource(policyMappingPath);
        if (resource != null) {
            return (ContentPolicyMapping)resource.adaptTo(ContentPolicyMapping.class);
        }
        return null;
    }

    private static String buildPolicyMappingPath(@NotNull String relativeResourceType) {
        return "/conf/$aem-mock$/settings/wcm/templates/$mock-template$/policies/jcr:content/" + relativeResourceType;
    }

    private static Resource storeResource(@NotNull String path, @NotNull Map<String, Object> properties, @NotNull ResourceResolver resourceResolver, @NotNull ContentBuilder builder) {
        Resource resource = resourceResolver.getResource(path);
        if (resource != null) {
            try {
                resourceResolver.delete(resource);
            }
            catch (PersistenceException ex) {
                throw new RuntimeException("Unable to delete resource " + path, ex);
            }
        }
        return builder.resource(path, properties);
    }

    private static void ensureMockTemplate(@NotNull ResourceResolver resourceResolver, @NotNull ContentBuilder builder) {
        Resource template = resourceResolver.getResource(MOCK_TEMPLATE_PATH);
        if (template == null) {
            template = builder.resource(MOCK_TEMPLATE_PATH, new Object[]{"jcr:primaryType", "cq:Template"});
            builder.resource(template, "jcr:content", new Object[]{"jcr:primaryType", "cq:PageContent", "jcr:title", template.getName()});
            builder.page(template.getPath() + "/initial");
            builder.page(template.getPath() + "/policies");
            builder.page(template.getPath() + "/structure");
        }
    }

    @NotNull
    private static String makeResourceTypeRelative(@NotNull String resourceType) {
        if (StringUtils.startsWith((CharSequence)resourceType, (CharSequence)"/apps/")) {
            return StringUtils.substringAfter((String)resourceType, (String)"/apps/");
        }
        if (StringUtils.startsWith((CharSequence)resourceType, (CharSequence)"/libs/")) {
            return StringUtils.substringAfter((String)resourceType, (String)"/libs/");
        }
        if (StringUtils.startsWith((CharSequence)resourceType, (CharSequence)"/")) {
            return StringUtils.substringAfter((String)resourceType, (String)"/");
        }
        return resourceType;
    }
}

