/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.context;

import io.wcm.testing.mock.aem.context.AemContextImpl;
import io.wcm.testing.mock.aem.context.MockAemSlingBindings;
import java.util.Map;
import javax.script.Bindings;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.scripting.LazyBindings;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={BindingsValuesProvider.class}, property={"MockSlingBindings-ignore=true"})
class MockAemBindingsValuesProvider
implements BindingsValuesProvider {
    static final String PROPERTY_CONTEXT = "context";
    private volatile AemContextImpl context;

    MockAemBindingsValuesProvider() {
    }

    @Activate
    private void activate(Map<String, Object> config) {
        this.context = (AemContextImpl)((Object)config.get(PROPERTY_CONTEXT));
    }

    @Deactivate
    private void deactivate() {
        this.context = null;
    }

    public void addBindings(Bindings bindings) {
        if (this.context == null) {
            return;
        }
        SlingHttpServletRequest request = (SlingHttpServletRequest)bindings.get("request");
        for (MockAemSlingBindings.SlingBindingsProperty property : MockAemSlingBindings.SlingBindingsProperty.values()) {
            this.putProperty(bindings, property.key(), request);
        }
    }

    private void putProperty(Bindings bindings, String key, SlingHttpServletRequest request) {
        if (bindings instanceof LazyBindings) {
            bindings.put(key, () -> MockAemSlingBindings.resolveSlingBindingProperty(this.context, key, request));
        } else {
            Object value = MockAemSlingBindings.resolveSlingBindingProperty(this.context, key, request);
            if (value != null) {
                bindings.put(key, value);
            }
        }
    }
}

