/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Revision;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.api.msm.Blueprint;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;

class MockPageManager
extends SlingAdaptable
implements PageManager {
    private final ResourceResolver resourceResolver;

    MockPageManager(@NotNull ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public Page create(String parentPath, String pageName, String template, String title) throws WCMException {
        return this.create(parentPath, pageName, template, title, false);
    }

    public Page create(String parentPath, String pageName, String template, String title, boolean autoSave) throws WCMException {
        Resource pageResource;
        Resource parentResource = this.resourceResolver.getResource(parentPath);
        if (parentResource == null) {
            throw new WCMException(String.format("Parent path '%s' does not exist.", parentPath));
        }
        if (StringUtils.isEmpty((CharSequence)pageName) && StringUtils.isEmpty((CharSequence)title)) {
            throw new IllegalArgumentException("Either page name or title must be specified.");
        }
        String childResourceName = pageName;
        if (StringUtils.isEmpty((CharSequence)childResourceName)) {
            childResourceName = JcrUtil.createValidName((String)title, (String[])JcrUtil.HYPHEN_LABEL_CHAR_MAPPING, (String)"_");
        } else if (!JcrUtil.isValidName((String)childResourceName)) {
            throw new IllegalArgumentException("Illegal page name.");
        }
        try {
            childResourceName = ResourceUtil.createUniqueChildName((Resource)parentResource, (String)childResourceName);
        }
        catch (PersistenceException ex) {
            throw new WCMException("Unable to get unique child name.", (Throwable)ex);
        }
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("jcr:primaryType", "cq:Page");
            pageResource = this.resourceResolver.create(parentResource, childResourceName, props);
            props = new HashMap();
            props.put("jcr:primaryType", "cq:PageContent");
            props.put("jcr:title", title);
            if (template != null) {
                props.put("cq:template", template);
            }
            Resource contentResource = this.resourceResolver.create(pageResource, "jcr:content", props);
            if (template != null) {
                this.createInitialContentFromTemplate(contentResource, template);
            }
            if (autoSave) {
                this.resourceResolver.commit();
            }
        }
        catch (PersistenceException ex) {
            throw new WCMException("Creating page failed at :" + parentPath + "/" + childResourceName + " failed.", (Throwable)ex);
        }
        return (Page)pageResource.adaptTo(Page.class);
    }

    private void createInitialContentFromTemplate(@NotNull Resource contentResource, @NotNull String template) throws PersistenceException {
        String initialContentPath;
        Resource initialContentResource;
        Template templateInstance;
        Resource templateResource = this.resourceResolver.getResource(template);
        if (templateResource != null && (templateInstance = (Template)templateResource.adaptTo(Template.class)) != null && (initialContentResource = this.resourceResolver.getResource(initialContentPath = templateInstance.getInitialContentPath())) != null) {
            this.copyContent(initialContentResource, contentResource, true);
        }
    }

    @SuppressFBWarnings(value={"STYLE"})
    private void copyContent(Resource source, Resource target, boolean skipPrimaryType) throws PersistenceException {
        ValueMap sourceProps = (ValueMap)source.adaptTo(ValueMap.class);
        ModifiableValueMap targetProps = (ModifiableValueMap)target.adaptTo(ModifiableValueMap.class);
        Node node = (Node)target.adaptTo(Node.class);
        for (Map.Entry entry : sourceProps.entrySet()) {
            if (skipPrimaryType && StringUtils.equals((CharSequence)((CharSequence)entry.getKey()), (CharSequence)"jcr:primaryType")) continue;
            if (node != null) {
                try {
                    Property property = node.getProperty((String)entry.getKey());
                    if (property.getDefinition().isProtected()) {
                        continue;
                    }
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
            targetProps.put((Object)((String)entry.getKey()), entry.getValue());
        }
        this.copyChildren(source, target);
    }

    private void copyChildren(Resource source, Resource target) throws PersistenceException {
        for (Resource sourceChild : source.getChildren()) {
            Resource targetChild = this.resourceResolver.create(target, sourceChild.getName(), (Map)sourceChild.adaptTo(ValueMap.class));
            this.copyChildren(sourceChild, targetChild);
        }
    }

    @SuppressFBWarnings(value={"STYLE"})
    public void delete(Page page, boolean shallow) throws WCMException {
        this.delete((Resource)page.adaptTo(Resource.class), shallow);
    }

    @SuppressFBWarnings(value={"STYLE"})
    public void delete(Page page, boolean shallow, boolean autoSave) throws WCMException {
        this.delete((Resource)page.adaptTo(Resource.class), shallow, autoSave);
    }

    public void delete(Resource resource, boolean shallow) throws WCMException {
        this.delete(resource, shallow, false);
    }

    public void delete(Resource resource, boolean shallow, boolean autoSave) throws WCMException {
        try {
            if (shallow) {
                Resource contentResource = resource.getChild("jcr:content");
                if (contentResource != null) {
                    this.resourceResolver.delete(contentResource);
                }
            } else {
                this.resourceResolver.delete(resource);
            }
            if (autoSave) {
                this.resourceResolver.commit();
            }
        }
        catch (PersistenceException ex) {
            throw new WCMException("Deleting resource at " + resource.getPath() + " failed.", (Throwable)ex);
        }
    }

    public Page getContainingPage(Resource resource) {
        if (resource == null) {
            return null;
        }
        for (Resource pageResource = resource; pageResource != null; pageResource = pageResource.getParent()) {
            Page page = (Page)pageResource.adaptTo(Page.class);
            if (page == null) continue;
            return page;
        }
        return null;
    }

    public Page getContainingPage(String path) {
        Resource resource = this.resourceResolver.getResource(path);
        return this.getContainingPage(resource);
    }

    public Page getPage(String path) {
        Resource resource = this.resourceResolver.getResource(path);
        if (resource != null) {
            return (Page)resource.adaptTo(Page.class);
        }
        return null;
    }

    public Template getTemplate(String templatePath) {
        Resource resource = this.resourceResolver.getResource(templatePath);
        if (resource != null) {
            return (Template)resource.adaptTo(Template.class);
        }
        return null;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ResourceResolver.class) {
            return (AdapterType)this.resourceResolver;
        }
        return (AdapterType)super.adaptTo(type);
    }

    public void touch(Node page, boolean shallow, Calendar now, boolean clearRepl) throws WCMException {
        if (!shallow) {
            throw new UnsupportedOperationException("Only shallow touch supported");
        }
        try {
            Resource pageContent = this.resourceResolver.getResource(page.getPath() + "/jcr:content");
            if (pageContent != null) {
                ModifiableValueMap properties = (ModifiableValueMap)pageContent.adaptTo(ModifiableValueMap.class);
                if (now != null) {
                    properties.put((Object)"cq:lastModified", (Object)now);
                    properties.put((Object)"cq:lastModifiedBy", (Object)this.resourceResolver.getUserID());
                }
                if (clearRepl) {
                    properties.remove((Object)"cq:lastReplicated");
                    properties.remove((Object)"cq:lastReplicatedBy");
                    properties.remove((Object)"cq:lastReplicationAction");
                    properties.remove((Object)"cq:lastPublished");
                    properties.remove((Object)"cq:lastPublishedBy");
                }
            }
        }
        catch (RepositoryException ex) {
            throw new WCMException((Throwable)ex);
        }
    }

    public Page move(Page page, String destination, String beforeName, boolean shallow, boolean resolveConflict, String[] adjustRefs) {
        throw new UnsupportedOperationException();
    }

    public Resource move(Resource resource, String destination, String beforeName, boolean shallow, boolean resolveConflict, String[] adjustRefs) {
        throw new UnsupportedOperationException();
    }

    public Page copy(Page page, String destination, String beforeName, boolean shallow, boolean resolveConflict) {
        throw new UnsupportedOperationException();
    }

    public Page copy(Page page, String destination, String beforeName, boolean shallow, boolean resolveConflict, boolean autoSave) {
        throw new UnsupportedOperationException();
    }

    public Resource copy(Resource resource, String destination, String beforeName, boolean shallow, boolean resolveConflict) {
        throw new UnsupportedOperationException();
    }

    public Resource copy(Resource resource, String destination, String beforeName, boolean shallow, boolean resolveConflict, boolean autoSave) {
        throw new UnsupportedOperationException();
    }

    public void order(Page page, String beforeName) {
        throw new UnsupportedOperationException();
    }

    public void order(Page page, String beforeName, boolean autoSave) {
        throw new UnsupportedOperationException();
    }

    public void order(Resource resource, String beforeName) {
        throw new UnsupportedOperationException();
    }

    public void order(Resource resource, String beforeName, boolean autoSave) {
        throw new UnsupportedOperationException();
    }

    public Collection<Template> getTemplates(String parentPath) {
        throw new UnsupportedOperationException();
    }

    public Collection<Blueprint> getBlueprints(String parentPath) {
        throw new UnsupportedOperationException();
    }

    public Revision createRevision(Page page) throws WCMException {
        throw new UnsupportedOperationException();
    }

    public Revision createRevision(Page page, String label, String comment) {
        throw new UnsupportedOperationException();
    }

    public Collection<Revision> getRevisions(String path, Calendar cal) {
        throw new UnsupportedOperationException();
    }

    public Collection<Revision> getRevisions(String path, Calendar cal, boolean includeNoLocal) {
        throw new UnsupportedOperationException();
    }

    public Collection<Revision> getChildRevisions(String parentPath, Calendar cal) {
        throw new UnsupportedOperationException();
    }

    public Collection<Revision> getChildRevisions(String parentPath, Calendar cal, boolean includeNoLocal) {
        throw new UnsupportedOperationException();
    }

    public Collection<Revision> getChildRevisions(String parentPath, String treeRoot, Calendar cal) {
        throw new UnsupportedOperationException();
    }

    public Page restore(String path, String revisionId) {
        throw new UnsupportedOperationException();
    }

    public Page restoreTree(String path, Calendar date) {
        throw new UnsupportedOperationException();
    }

    public Page restoreTree(String path, Calendar date, boolean preserveNV) {
        throw new UnsupportedOperationException();
    }

    public Page move(Page page, String destination, String beforeName, boolean shallow, boolean resolveConflict, String[] adjustRefs, String[] publishRefs) throws WCMException {
        throw new UnsupportedOperationException();
    }

    public Resource move(Resource resource, String destination, String beforeName, boolean shallow, boolean resolveConflict, String[] adjustRefs, String[] publishRefs) throws WCMException {
        throw new UnsupportedOperationException();
    }

    public Resource move(Resource resource, String destination, String beforeName, boolean shallow, boolean resolveConflict, String[] adjustRefs, String[] publishRefs, String arg7) throws WCMException {
        throw new UnsupportedOperationException();
    }

    public Resource copy(PageManager.CopyOptions options) throws WCMException {
        throw new UnsupportedOperationException();
    }

    public void delete(Resource arg0, boolean arg1, boolean arg2, boolean arg3) throws WCMException {
        throw new UnsupportedOperationException();
    }

    public Resource override(PageManager.CopyOptions options) throws WCMException {
        throw new UnsupportedOperationException();
    }
}

