/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.adobe.cq.wcm.launches.utils.LaunchUtils;
import com.day.cq.commons.Filter;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.commons.DeepResourceIterator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;

class MockPage
extends SlingAdaptable
implements Page {
    private static final String RT_LAUNCH = "wcm/launches/components/launch";
    private final Resource resource;
    private final Resource contentResource;
    private final ResourceResolver resourceResolver;
    private final ValueMap properties;

    MockPage(@NotNull Resource resource) {
        this.resource = resource;
        this.contentResource = this.resource.getChild("jcr:content");
        this.resourceResolver = resource.getResourceResolver();
        this.properties = this.contentResource != null ? this.contentResource.getValueMap() : ValueMap.EMPTY;
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public String getName() {
        return this.resource.getName();
    }

    public String getTitle() {
        return (String)this.properties.get("jcr:title", String.class);
    }

    public String getPageTitle() {
        return (String)this.properties.get("pageTitle", String.class);
    }

    public String getNavigationTitle() {
        return (String)this.properties.get("navTitle", String.class);
    }

    public String getDescription() {
        return (String)this.properties.get("jcr:description", String.class);
    }

    public PageManager getPageManager() {
        return (PageManager)this.resourceResolver.adaptTo(PageManager.class);
    }

    public Resource getContentResource() {
        return this.contentResource;
    }

    public Resource getContentResource(String relPath) {
        return this.contentResource.getChild(relPath);
    }

    public boolean hasChild(String name) {
        return this.resource.getChild(name) != null;
    }

    public int getDepth() {
        if (StringUtils.equals((CharSequence)"/", (CharSequence)this.resource.getPath())) {
            return 0;
        }
        return StringUtils.countMatches((CharSequence)this.resource.getPath(), (CharSequence)"/");
    }

    public Page getParent() {
        Resource parentResource = this.resource.getParent();
        if (parentResource != null) {
            return (Page)parentResource.adaptTo(Page.class);
        }
        return null;
    }

    public Page getParent(int level) {
        String parentPath = ResourceUtil.getParent((String)this.resource.getPath(), (int)level);
        return this.getPage(parentPath);
    }

    private Page getPage(String path) {
        Resource pageResource;
        if (StringUtils.isNotEmpty((CharSequence)path) && (pageResource = this.resourceResolver.getResource(path)) != null) {
            return (Page)pageResource.adaptTo(Page.class);
        }
        return null;
    }

    public Page getAbsoluteParent(int level) {
        Resource launchResource;
        int hierachyLevel = level;
        if (LaunchUtils.isLaunchBasedPath((String)this.resource.getPath()) && (launchResource = MockPage.getLaunchResourceInternal(this.resource)) != null) {
            hierachyLevel += StringUtils.countMatches((CharSequence)launchResource.getPath(), (CharSequence)"/");
        }
        String parentPath = Text.getAbsoluteParent((String)this.resource.getPath(), (int)hierachyLevel);
        return this.getPage(parentPath);
    }

    private static Resource getLaunchResourceInternal(Resource resource) {
        if (resource == null) {
            return null;
        }
        Resource content = resource.getChild("jcr:content");
        if (content != null && content.isResourceType(RT_LAUNCH)) {
            return resource;
        }
        return MockPage.getLaunchResourceInternal(resource.getParent());
    }

    public ValueMap getProperties() {
        return this.properties;
    }

    public ValueMap getProperties(String relPath) {
        Resource childResource = this.getContentResource(relPath);
        if (childResource != null) {
            return childResource.getValueMap();
        }
        return null;
    }

    public boolean isHideInNav() {
        return (Boolean)this.properties.get("hideInNav", (Object)false);
    }

    public boolean hasContent() {
        return this.contentResource != null;
    }

    public boolean isValid() {
        return this.timeUntilValid() == 0L;
    }

    public long timeUntilValid() {
        long timeDiffOff;
        long timeDiffOn;
        if (!this.hasContent()) {
            return Long.MIN_VALUE;
        }
        Calendar on = this.getOnTime();
        Calendar off = this.getOffTime();
        if (on == null && off == null) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long l = timeDiffOn = on == null ? 0L : on.getTimeInMillis() - now;
        if (timeDiffOn > 0L) {
            return timeDiffOn;
        }
        long l2 = timeDiffOff = off == null ? 0L : off.getTimeInMillis() - now;
        if (timeDiffOff < 0L) {
            return timeDiffOff;
        }
        return 0L;
    }

    public Calendar getOnTime() {
        return (Calendar)this.properties.get("onTime", Calendar.class);
    }

    public Calendar getOffTime() {
        return (Calendar)this.properties.get("offTime", Calendar.class);
    }

    public String getLastModifiedBy() {
        return (String)this.properties.get("cq:lastModifiedBy", String.class);
    }

    public Calendar getLastModified() {
        return (Calendar)this.properties.get("cq:lastModified", Calendar.class);
    }

    public String getVanityUrl() {
        return (String)this.properties.get("sling:vanityPath", String.class);
    }

    public Template getTemplate() {
        Resource templateResource;
        String templatePath = (String)this.properties.get("cq:template", String.class);
        if (StringUtils.isNotEmpty((CharSequence)templatePath) && (templateResource = this.resourceResolver.getResource(templatePath)) != null) {
            return (Template)templateResource.adaptTo(Template.class);
        }
        return null;
    }

    public Iterator<Page> listChildren() {
        return this.listChildren(null);
    }

    public Iterator<Page> listChildren(Filter<Page> filter) {
        return this.listChildren(filter, false);
    }

    public Iterator<Page> listChildren(Filter<Page> filter, boolean deep) {
        Object resources = deep ? new DeepResourceIterator(this.resource) : this.resource.getResourceResolver().listChildren(this.resource);
        Iterator pages = IteratorUtils.transformedIterator((Iterator)resources, resourceItem -> (Page)resourceItem.adaptTo(Page.class));
        return IteratorUtils.filteredIterator((Iterator)pages, pageItem -> pageItem != null && (filter == null || filter.includes(pageItem)));
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Resource.class) {
            return (AdapterType)this.resource;
        }
        Object result = super.adaptTo(type);
        if (result == null) {
            result = this.resource.adaptTo(type);
        }
        return (AdapterType)result;
    }

    public Locale getLanguage() {
        return this.getLanguage(false);
    }

    public Locale getLanguage(boolean ignoreContent) {
        Locale contentLocale;
        HierarchyNodeInheritanceValueMap inheritanceValueMap;
        String language;
        if (!ignoreContent && (language = (String)(inheritanceValueMap = new HierarchyNodeInheritanceValueMap(this.getContentResource())).getInherited("jcr:language", String.class)) != null && (contentLocale = LanguageUtil.getLocale((String)language)) != null) {
            return contentLocale;
        }
        Locale localeFromPath = this.getLocaleFromPath(this);
        if (localeFromPath != null) {
            return localeFromPath;
        }
        return Locale.getDefault();
    }

    private Locale getLocaleFromPath(Page page) {
        Locale locale = LanguageUtil.getLocale((String)page.getName());
        if (locale != null) {
            return locale;
        }
        Page parentPage = page.getParent();
        if (parentPage != null) {
            return this.getLocaleFromPath(parentPage);
        }
        return null;
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MockPage)) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.getPath(), (CharSequence)((MockPage)((Object)obj)).getPath());
    }

    @SuppressFBWarnings(value={"STYLE"})
    public Tag[] getTags() {
        return ((TagManager)this.resourceResolver.adaptTo(TagManager.class)).getTags(this.contentResource);
    }

    public String toString() {
        return "MockPage [path=" + this.resource.getPath() + ", props=" + String.valueOf(this.properties) + "]";
    }

    public Calendar getDeleted() {
        return null;
    }

    public String getDeletedBy() {
        return null;
    }

    public void lock() {
        throw new UnsupportedOperationException();
    }

    public boolean isLocked() {
        throw new UnsupportedOperationException();
    }

    public String getLockOwner() {
        throw new UnsupportedOperationException();
    }

    public boolean canUnlock() {
        throw new UnsupportedOperationException();
    }

    public void unlock() throws WCMException {
        throw new UnsupportedOperationException();
    }
}

