/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.context;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.testing.mock.sling.MockSling;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
final class ContextResourceResolverFactory {
    private static final Logger log = LoggerFactory.getLogger(ContextResourceResolverFactory.class);

    private ContextResourceResolverFactory() {
    }

    @NotNull
    public static ResourceResolverFactory get(@NotNull ResourceResolverType resourceResolverType, @NotNull BundleContext bundleContext) {
        try {
            log.debug("Start initialize resource resolver factory, bundleContext={}", (Object)bundleContext);
            ResourceResolverFactory factory = MockSling.newResourceResolverFactory((ResourceResolverType)resourceResolverType, (BundleContext)bundleContext);
            switch (resourceResolverType) {
                case JCR_MOCK: {
                    ContextResourceResolverFactory.initializeJcrMock(factory);
                    break;
                }
                case JCR_OAK: {
                    ContextResourceResolverFactory.initializeJcrOak(factory);
                    break;
                }
                case RESOURCERESOLVER_MOCK: {
                    ContextResourceResolverFactory.initializeResourceResolverMock(factory);
                    break;
                }
                case RESOURCEPROVIDER_MOCK: {
                    ContextResourceResolverFactory.initializeResourceProviderMock(factory);
                    break;
                }
                case NONE: {
                    ContextResourceResolverFactory.initializeResourceResolverNone(factory);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid resource resolver type: " + String.valueOf(resourceResolverType));
                }
            }
            log.debug("Finished initializing resource resolver factory, bundleContext={}", (Object)bundleContext);
            return factory;
        }
        catch (Exception ex) {
            log.error("Failed initializing resource resolver factory, bundleContext={}", (Object)bundleContext, (Object)ex);
            throw new RuntimeException("Unable to initialize " + String.valueOf(resourceResolverType) + " resource resolver factory: " + ex.getMessage(), ex);
        }
    }

    private static void initializeJcrMock(ResourceResolverFactory factory) throws RepositoryException, LoginException {
        try (ResourceResolver resolver = factory.getResourceResolver(null);){
            ContextResourceResolverFactory.registerDefaultAemNamespaces(resolver);
        }
    }

    private static void initializeJcrOak(ResourceResolverFactory factory) {
    }

    private static void initializeResourceResolverMock(ResourceResolverFactory factory) {
    }

    private static void initializeResourceProviderMock(ResourceResolverFactory factory) {
    }

    private static void initializeResourceResolverNone(ResourceResolverFactory factory) {
    }

    @SuppressFBWarnings(value={"STYLE"})
    private static void registerDefaultAemNamespaces(ResourceResolver resolver) throws RepositoryException {
        Session session = (Session)resolver.adaptTo(Session.class);
        NamespaceRegistry namespaceRegistry = session.getWorkspace().getNamespaceRegistry();
        namespaceRegistry.registerNamespace("cq", "http://www.day.com/jcr/cq/1.0");
        namespaceRegistry.registerNamespace("dam", "http://www.day.com/dam/1.0 ");
    }
}

