/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.dam;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import io.wcm.testing.mock.aem.dam.MockAsset;
import io.wcm.testing.mock.aem.dam.MockAssetManager;
import io.wcm.testing.mock.aem.dam.MockGraniteAssetManagerWrapper;
import io.wcm.testing.mock.aem.dam.MockGraniteAssetWrapper;
import io.wcm.testing.mock.aem.dam.MockRendition;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;

@Component(service={AdapterFactory.class}, property={"adaptables=org.apache.sling.api.resource.Resource", "adaptables=org.apache.sling.api.resource.ResourceResolver", "adapters=com.day.cq.dam.api.Asset", "adapters=com.day.cq.dam.api.AssetManager", "adapters=com.day.cq.dam.api.Rendition", "adapters=com.adobe.granite.asset.api.Asset", "adapters=com.adobe.granite.asset.api.AssetManager", "adapters=com.adobe.granite.asset.api.Rendition"})
@ProviderType
public final class MockAemDamAdapterFactory
implements AdapterFactory {
    @Reference
    private EventAdmin eventAdmin;
    private BundleContext bundleContext;

    @Activate
    private void activate(BundleContext context) {
        this.bundleContext = context;
    }

    @Nullable
    public <AdapterType> AdapterType getAdapter(@NotNull Object adaptable, @NotNull Class<AdapterType> type) {
        if (adaptable instanceof Resource) {
            return this.getAdapter((Resource)adaptable, type);
        }
        if (adaptable instanceof ResourceResolver) {
            return this.getAdapter((ResourceResolver)adaptable, type);
        }
        return null;
    }

    @Nullable
    private <AdapterType> AdapterType getAdapter(@NotNull Resource resource, @NotNull Class<AdapterType> type) {
        if (DamUtil.isAsset((Resource)resource)) {
            if (type == com.adobe.granite.asset.api.Asset.class) {
                return type.cast((Object)new MockGraniteAssetWrapper(new MockAsset(resource, this.eventAdmin, this.bundleContext), resource));
            }
            if (type == Asset.class) {
                return type.cast((Object)new MockAsset(resource, this.eventAdmin, this.bundleContext));
            }
        }
        if ((type == Rendition.class || type == com.adobe.granite.asset.api.Rendition.class) && DamUtil.isRendition((Resource)resource)) {
            return type.cast((Object)new MockRendition(resource));
        }
        return null;
    }

    @Nullable
    private <AdapterType> AdapterType getAdapter(@NotNull ResourceResolver resolver, @NotNull Class<AdapterType> type) {
        if (type == AssetManager.class) {
            return type.cast(new MockAssetManager(resolver, this.eventAdmin, this.bundleContext));
        }
        if (type == com.adobe.granite.asset.api.AssetManager.class) {
            return type.cast(new MockGraniteAssetManagerWrapper(resolver));
        }
        return null;
    }
}

