/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.dam;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.binary.BinaryDownload;
import org.apache.jackrabbit.api.binary.BinaryDownloadOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MockRendition
extends ResourceWrapper
implements Rendition,
com.adobe.granite.asset.api.Rendition {
    private final Resource resource;
    private final Resource contentResource;
    private final ValueMap contentProps;

    MockRendition(@NotNull Resource resource) {
        super(resource);
        this.resource = resource;
        this.contentResource = resource.getChild("jcr:content");
        this.contentProps = ResourceUtil.getValueMap((Resource)this.contentResource);
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Resource.class) {
            return (AdapterType)this.resource;
        }
        if (type == Rendition.class || type == com.adobe.granite.asset.api.Rendition.class) {
            return (AdapterType)((Object)this);
        }
        return (AdapterType)super.adaptTo(type);
    }

    public ValueMap getProperties() {
        return this.contentProps;
    }

    public String getMimeType() {
        return (String)this.contentProps.get("jcr:mimeType", String.class);
    }

    public InputStream getStream() {
        Resource data = this.contentResource.getChild("jcr:data");
        if (data != null) {
            return (InputStream)data.adaptTo(InputStream.class);
        }
        return null;
    }

    public long getSize() {
        try {
            InputStream is = this.getStream();
            if (is == null) {
                return 0L;
            }
            return IOUtils.toByteArray((InputStream)is).length;
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to read binary data: " + this.getPath(), ex);
        }
    }

    public Asset getAsset() {
        return DamUtil.resolveToAsset((Resource)this.resource);
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MockRendition)) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.getPath(), (CharSequence)((MockRendition)((Object)obj)).getPath());
    }

    public Binary getBinary() {
        return new MockBinary(this);
    }

    private static class MockBinary
    implements BinaryDownload {
        private Rendition rendition;

        MockBinary(Rendition rendition) {
            this.rendition = rendition;
        }

        public InputStream getStream() throws RepositoryException {
            return this.rendition.getStream();
        }

        public int read(byte[] b, long position) throws IOException, RepositoryException {
            throw new UnsupportedOperationException();
        }

        public long getSize() throws RepositoryException {
            return this.rendition.getSize();
        }

        public void dispose() {
        }

        @Nullable
        public URI getURI(BinaryDownloadOptions downloadOptions) throws RepositoryException {
            String path = "https://blostore.local/blostore/" + this.rendition.getPath();
            try {
                return new URI(path);
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
    }
}

