/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.commons.Externalizer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;

@Component(service={Externalizer.class})
public final class MockExternalizer
implements Externalizer {
    private static final String DEFAULT_URI_AUTHOR = "http://localhost:4502";
    private static final String DEFAULT_URI_PUBLISH = "http://localhost:4503";
    private static final String SCHEME_SEPARATOR = "://";
    private final Map<String, URI> domainMappings = new HashMap<String, URI>();

    public MockExternalizer() {
        try {
            this.domainMappings.put("local", new URI(DEFAULT_URI_AUTHOR));
            this.domainMappings.put("author", new URI(DEFAULT_URI_AUTHOR));
            this.domainMappings.put("publish", new URI(DEFAULT_URI_PUBLISH));
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void setMapping(String domain, String domainURI) {
        try {
            this.domainMappings.put(domain, new URI(domainURI));
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid URI: " + domainURI, ex);
        }
    }

    public String externalLink(ResourceResolver resourceResolver, String domain, String path) {
        return this.externalLink(resourceResolver, domain, null, path);
    }

    public String externalLink(ResourceResolver resourceResolver, String domain, String scheme, String path) {
        return this.buildExternalLink(resourceResolver, domain, scheme, path);
    }

    public String authorLink(ResourceResolver resourceResolver, String path) {
        return this.externalLink(resourceResolver, "author", null, path);
    }

    public String authorLink(ResourceResolver resourceResolver, String scheme, String path) {
        return this.externalLink(resourceResolver, "author", scheme, path);
    }

    public String publishLink(ResourceResolver resourceResolver, String path) {
        return this.externalLink(resourceResolver, "publish", null, path);
    }

    public String publishLink(ResourceResolver resourceResolver, String scheme, String path) {
        return this.externalLink(resourceResolver, "publish", scheme, path);
    }

    public String absoluteLink(ResourceResolver resourceResolver, String scheme, String path) {
        return this.externalLink(resourceResolver, "local", scheme, path);
    }

    public String absoluteLink(SlingHttpServletRequest request, String scheme, String path) {
        return this.buildAbsoluteLink(request, scheme, path);
    }

    public String absoluteLink(String scheme, String path) {
        return this.externalLink(null, "local", scheme, path);
    }

    public String relativeLink(SlingHttpServletRequest request, String path) {
        return MockExternalizer.getMappedPath(request.getResourceResolver(), path);
    }

    private String buildExternalLink(@Nullable ResourceResolver resourceResolver, @NotNull String domain, @Nullable String scheme, @NotNull String path) {
        URI domainURI = this.domainMappings.get(Objects.requireNonNull(domain));
        if (domainURI == null) {
            throw new IllegalArgumentException("No mapping defined for: " + domain);
        }
        StringBuilder url = new StringBuilder();
        url.append(StringUtils.defaultString((String)scheme, (String)StringUtils.defaultString((String)domainURI.getScheme(), (String)"http"))).append(SCHEME_SEPARATOR).append(MockExternalizer.getHost(scheme, domainURI.getHost(), domainURI.getPort()));
        if (domainURI.getRawPath() != null) {
            url.append(domainURI.getRawPath());
        }
        url.append(MockExternalizer.getMappedPath(resourceResolver, path));
        return url.toString();
    }

    private String buildAbsoluteLink(@NotNull SlingHttpServletRequest request, @NotNull String scheme, @NotNull String path) {
        if (StringUtils.contains((CharSequence)path, (CharSequence)SCHEME_SEPARATOR)) {
            return path;
        }
        StringBuilder url = new StringBuilder();
        url.append(scheme).append(SCHEME_SEPARATOR).append(MockExternalizer.getHost(scheme, request.getServerName(), request.getServerPort())).append(request.getContextPath()).append(MockExternalizer.getMappedPath(request.getResourceResolver(), path));
        return url.toString();
    }

    private static String getHost(String scheme, String host, int port) {
        if (port < 0 || StringUtils.equals((CharSequence)scheme, (CharSequence)"http") && port == 80 || StringUtils.equals((CharSequence)scheme, (CharSequence)"https") && port == 443) {
            return host;
        }
        return host + ":" + port;
    }

    private static String getMappedPath(@Nullable ResourceResolver resourceResolver, @NotNull String path) {
        if (resourceResolver == null) {
            return path;
        }
        return resourceResolver.map(path);
    }
}

