/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.junit;

import io.wcm.testing.junit.rules.parameterized.Callback;
import io.wcm.testing.junit.rules.parameterized.ListGenerator;
import io.wcm.testing.mock.aem.context.AemContextImpl;
import java.util.Arrays;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.context.ContextCallback;
import org.apache.sling.testing.mock.osgi.context.ContextPlugins;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.apache.sling.testing.mock.sling.MockSling;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.ExternalResource;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class AemContext
extends AemContextImpl
implements TestRule {
    private final ContextPlugins plugins;
    private final ResourceResolverType[] resourceResolverTypes;
    private final TestRule delegate;

    public AemContext(ResourceResolverType ... resourceResolverTypes) {
        this(new ContextPlugins(), null, resourceResolverTypes);
    }

    public <T extends OsgiContextImpl> AemContext(@NotNull ContextCallback<T> afterSetUpCallback, ResourceResolverType ... resourceResolverTypes) {
        this(new ContextPlugins(afterSetUpCallback), null, resourceResolverTypes);
    }

    public <U extends OsgiContextImpl, V extends OsgiContextImpl> AemContext(@NotNull ContextCallback<U> afterSetUpCallback, @NotNull ContextCallback<V> beforeTearDownCallback, ResourceResolverType ... resourceResolverTypes) {
        this(new ContextPlugins(afterSetUpCallback, beforeTearDownCallback), null, resourceResolverTypes);
    }

    AemContext(@NotNull ContextPlugins contextPlugins, @Nullable Map<String, Object> resourceResolverFactoryActivatorProps, ResourceResolverType ... resourceResolverTypes) {
        this(contextPlugins, resourceResolverFactoryActivatorProps, true, resourceResolverTypes);
    }

    AemContext(@NotNull ContextPlugins contextPlugins, @Nullable Map<String, Object> resourceResolverFactoryActivatorProps, boolean registerSlingModelsFromClassPath, ResourceResolverType ... resourceResolverTypes) {
        this.plugins = contextPlugins;
        Map mergedProps = this.resourceResolverFactoryActivatorPropsMergeWithAemDefault(resourceResolverFactoryActivatorProps);
        this.setResourceResolverFactoryActivatorProps(mergedProps);
        this.setRegisterSlingModelsFromClassPath(registerSlingModelsFromClassPath);
        this.resourceResolverTypes = resourceResolverTypes == null || resourceResolverTypes.length == 0 ? new ResourceResolverType[]{MockSling.DEFAULT_RESOURCERESOLVER_TYPE} : resourceResolverTypes;
        if (this.resourceResolverTypes.length == 1) {
            this.setResourceResolverType(this.resourceResolverTypes[0]);
            this.delegate = new ExternalResource(){

                protected void before() {
                    AemContext.this.plugins.executeBeforeSetUpCallback((OsgiContextImpl)AemContext.this);
                    AemContext.this.setUp();
                    AemContext.this.plugins.executeAfterSetUpCallback((OsgiContextImpl)AemContext.this);
                }

                protected void after() {
                    AemContext.this.plugins.executeBeforeTearDownCallback((OsgiContextImpl)AemContext.this);
                    AemContext.this.tearDown();
                    AemContext.this.plugins.executeAfterTearDownCallback((OsgiContextImpl)AemContext.this);
                }
            };
        } else {
            Callback<ResourceResolverType> parameterizedSetUpCallback = new Callback<ResourceResolverType>(){

                public void execute(ResourceResolverType currrentValue) {
                    AemContext.this.setResourceResolverType(currrentValue);
                    AemContext.this.plugins.executeBeforeSetUpCallback((OsgiContextImpl)AemContext.this);
                    AemContext.this.setUp();
                    AemContext.this.plugins.executeAfterSetUpCallback((OsgiContextImpl)AemContext.this);
                }
            };
            Callback<ResourceResolverType> parameterizedTearDownCallback = new Callback<ResourceResolverType>(){

                public void execute(ResourceResolverType currrentValue) {
                    AemContext.this.plugins.executeBeforeTearDownCallback((OsgiContextImpl)AemContext.this);
                    AemContext.this.tearDown();
                    AemContext.this.plugins.executeAfterTearDownCallback((OsgiContextImpl)AemContext.this);
                }
            };
            this.delegate = new ListGenerator(Arrays.asList(this.resourceResolverTypes), (Callback)parameterizedSetUpCallback, (Callback)parameterizedTearDownCallback);
        }
    }

    public Statement apply(Statement base, Description description) {
        return this.delegate.apply(base, description);
    }
}

