/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.junit5;

import io.wcm.testing.mock.aem.junit5.AemContext;
import io.wcm.testing.mock.aem.junit5.AemContextStore;
import io.wcm.testing.mock.aem.junit5.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public final class AemContextExtension
implements ParameterResolver,
TestInstancePostProcessor,
BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
AfterAllCallback,
AfterTestExecutionCallback {
    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) throws Exception {
        Field aemContextField;
        if (!this.isBeforeAllContext(extensionContext) && (aemContextField = ReflectionUtil.getField(testInstance, AemContext.class)) != null) {
            this.setAemContextInStore(extensionContext, aemContextField, testInstance);
        }
    }

    private void setAemContextInStore(@NotNull ExtensionContext extensionContext, @NotNull Field aemContextField, @Nullable Object testInstance) throws IllegalAccessException {
        AemContext aemContext = (AemContext)((Object)aemContextField.get(testInstance));
        if (aemContext != null) {
            if (!aemContext.isSetUp()) {
                aemContext.setUpContext();
            }
            AemContextStore.storeAemContext(extensionContext, aemContext);
        } else {
            aemContext = AemContextStore.getOrCreateAemContext(extensionContext, Optional.of(aemContextField.getType()));
            aemContextField.set(testInstance, (Object)aemContext);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return AemContext.class.isAssignableFrom(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        AemContext aemContext = AemContextStore.getOrCreateAemContext(extensionContext, this.getAemContextType(parameterContext, extensionContext));
        if (this.paramIsNotInstanceOfExistingContext(parameterContext, aemContext)) {
            throw new ParameterResolutionException("Found AemContext instance of type: " + ((Object)((Object)aemContext)).getClass().getName() + "\nRequired is: " + parameterContext.getParameter().getType().getName() + "\nVerify that all test lifecycle methods (@BeforeEach, @Test, @AfterEach) use the same AemContext type.");
        }
        return aemContext;
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        if (this.isBeforeAllContext(extensionContext)) {
            Field aemContextField = ReflectionUtil.getField(extensionContext.getRequiredTestClass(), AemContext.class);
            if (aemContextField != null) {
                this.setAemContextInStore(extensionContext, aemContextField, null);
            }
            this.applyAemContext(extensionContext, aemContext -> aemContext.getContextPlugins().executeAfterSetUpCallback((OsgiContextImpl)aemContext));
        }
    }

    public void beforeEach(ExtensionContext extensionContext) {
        if (!this.isBeforeAllContext(extensionContext)) {
            this.applyAemContext(extensionContext, aemContext -> aemContext.getContextPlugins().executeAfterSetUpCallback((OsgiContextImpl)aemContext));
        }
    }

    public void afterTestExecution(ExtensionContext extensionContext) {
        if (!this.isBeforeAllContext(extensionContext)) {
            this.applyAemContext(extensionContext, aemContext -> aemContext.getContextPlugins().executeBeforeTearDownCallback((OsgiContextImpl)aemContext));
        }
    }

    public void afterEach(ExtensionContext extensionContext) {
        if (!this.isBeforeAllContext(extensionContext)) {
            this.applyAemContext(extensionContext, aemContext -> {
                aemContext.getContextPlugins().executeAfterTearDownCallback((OsgiContextImpl)aemContext);
                aemContext.tearDownContext();
                AemContextStore.removeAemContext(extensionContext);
            });
        }
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        if (this.isBeforeAllContext(extensionContext)) {
            this.applyAemContext(extensionContext, aemContext -> {
                aemContext.getContextPlugins().executeBeforeTearDownCallback((OsgiContextImpl)aemContext);
                aemContext.getContextPlugins().executeAfterTearDownCallback((OsgiContextImpl)aemContext);
                aemContext.tearDownContext();
                AemContextStore.removeAemContext(extensionContext);
            });
        }
    }

    private void applyAemContext(ExtensionContext extensionContext, Consumer<AemContext> consumer) {
        AemContext aemContext = AemContextStore.getAemContext(extensionContext);
        if (aemContext != null) {
            consumer.accept(aemContext);
        }
    }

    private Optional<Class<?>> getAemContextType(ParameterContext parameterContext, ExtensionContext extensionContext) {
        if (this.isTestInstance(extensionContext) && this.isAbstractAemContext(parameterContext)) {
            return this.getParameterFromTestMethod(extensionContext, AemContext.class);
        }
        return Optional.of(parameterContext.getParameter().getType());
    }

    private boolean isTestInstance(ExtensionContext extensionContext) {
        return extensionContext.getTestInstance().isPresent();
    }

    private boolean isAbstractAemContext(ParameterContext parameterContext) {
        return parameterContext.getParameter().getType().equals(AemContext.class);
    }

    private boolean paramIsNotInstanceOfExistingContext(ParameterContext parameterContext, AemContext aemContext) {
        return !parameterContext.getParameter().getType().isInstance((Object)aemContext);
    }

    private Optional<Class<?>> getParameterFromTestMethod(ExtensionContext extensionContext, Class<?> type) {
        return Arrays.stream(extensionContext.getRequiredTestMethod().getParameterTypes()).filter(type::isAssignableFrom).findFirst();
    }

    private boolean isBeforeAllContext(@NotNull ExtensionContext extensionContext) {
        Boolean state = AemContextStore.getBeforeAllState(extensionContext);
        if (state == null) {
            state = false;
            Class testClass = extensionContext.getRequiredTestClass();
            Field aemContextField = ReflectionUtil.getField(testClass, AemContext.class);
            if (aemContextField != null && Modifier.isStatic(aemContextField.getModifiers())) {
                state = true;
            } else {
                Method method = ReflectionUtil.getAnnotatedMethod(testClass, BeforeAll.class, AemContext.class);
                if (method != null && Modifier.isStatic(method.getModifiers())) {
                    state = true;
                }
            }
            AemContextStore.storeBeforeAllState(extensionContext, state);
        }
        return state;
    }
}

