/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.junit5;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ReflectionUtil {
    private ReflectionUtil() {
    }

    @Nullable
    static Field getField(@NotNull Object testInstance, @NotNull Class<?> type) {
        return ReflectionUtil.getField(testInstance.getClass(), type);
    }

    @Nullable
    static Field getField(@Nullable Class<?> testClass, @NotNull Class<?> type) {
        if (testClass == null) {
            return null;
        }
        Field field = Arrays.stream(testClass.getDeclaredFields()).filter(item -> type.isAssignableFrom(item.getType())).findFirst().orElse(null);
        if (field == null) {
            return ReflectionUtil.getField(testClass.getSuperclass(), type);
        }
        field.setAccessible(true);
        return field;
    }

    @Nullable
    static <T extends Annotation> Method getAnnotatedMethod(@Nullable Class<?> testClass, @NotNull Class<T> annotationClass, @NotNull Class<?> parameterType) {
        if (testClass == null) {
            return null;
        }
        Method method = Arrays.stream(testClass.getDeclaredMethods()).filter(item -> item.getAnnotation(annotationClass) != null).filter(item -> ReflectionUtil.hasParameter(item, parameterType)).findFirst().orElse(null);
        if (method == null) {
            return ReflectionUtil.getAnnotatedMethod(testClass.getSuperclass(), annotationClass, parameterType);
        }
        return method;
    }

    private static boolean hasParameter(Method method, @NotNull Class<?> parameterType) {
        return Arrays.stream(method.getParameters()).anyMatch(item -> parameterType.isAssignableFrom(item.getType()));
    }
}

