/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.junit5;

import io.wcm.testing.mock.aem.junit5.AemContext;
import io.wcm.testing.mock.aem.junit5.AemContextExtension;
import io.wcm.testing.mock.aem.junit5.ResourceResolverMockAemContext;
import java.lang.reflect.Constructor;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.extension.ExtensionContext;

final class AemContextStore {
    private static final ExtensionContext.Namespace AEM_CONTEXT_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{AemContextExtension.class});
    private static final Class<ResourceResolverMockAemContext> DEFAULT_AEM_CONTEXT_TYPE = ResourceResolverMockAemContext.class;
    private static final String BEFORE_ALL_SUFFIX = "_BeforeAll";

    private AemContextStore() {
    }

    @Nullable
    public static AemContext getAemContext(@NotNull ExtensionContext extensionContext) {
        Class testClass = extensionContext.getTestClass().orElse(null);
        if (testClass == null) {
            return null;
        }
        return Optional.ofNullable((AemContext)((Object)AemContextStore.getStore(extensionContext).get((Object)testClass, AemContext.class))).orElseGet(() -> extensionContext.getParent().map(AemContextStore::getAemContext).orElse(null));
    }

    @NotNull
    public static AemContext getOrCreateAemContext(@NotNull ExtensionContext extensionContext, Optional<Class<?>> aemContextType) {
        AemContext context = AemContextStore.getAemContext(extensionContext);
        if (context == null) {
            context = AemContextStore.createAemContext(aemContextType);
            AemContextStore.storeAemContext(extensionContext, context);
        }
        return context;
    }

    public static void removeAemContext(@NotNull ExtensionContext extensionContext) {
        Class testClass = extensionContext.getRequiredTestClass();
        AemContextStore.getStore(extensionContext).remove((Object)testClass);
    }

    public static void storeAemContext(@NotNull ExtensionContext extensionContext, @NotNull AemContext aemContext) {
        Class testClass = extensionContext.getRequiredTestClass();
        AemContextStore.getStore(extensionContext).put((Object)testClass, (Object)aemContext);
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(AEM_CONTEXT_NAMESPACE);
    }

    private static AemContext createAemContext(Optional<Class<?>> aemContextType) {
        Class<ResourceResolverMockAemContext> type = aemContextType.orElse(DEFAULT_AEM_CONTEXT_TYPE);
        if (type == AemContext.class) {
            type = DEFAULT_AEM_CONTEXT_TYPE;
        }
        try {
            Constructor<ResourceResolverMockAemContext> constructor = type.getConstructor(new Class[0]);
            AemContext aemContext = constructor.newInstance(new Object[0]);
            aemContext.setUpContext();
            return aemContext;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not create " + type.getName() + " instance.", ex);
        }
    }

    @Nullable
    public static Boolean getBeforeAllState(@NotNull ExtensionContext extensionContext) {
        Class testClass = extensionContext.getRequiredTestClass();
        return (Boolean)AemContextStore.getStore(extensionContext).get((Object)(testClass.getName() + BEFORE_ALL_SUFFIX), Boolean.class);
    }

    public static void storeBeforeAllState(@NotNull ExtensionContext extensionContext, @NotNull Boolean state) {
        Class testClass = extensionContext.getRequiredTestClass();
        AemContextStore.getStore(extensionContext).put((Object)(testClass.getName() + BEFORE_ALL_SUFFIX), (Object)state);
    }
}

