/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.commons.RangeIterator;
import java.util.Collection;
import java.util.Iterator;

class CollectionRangeIterator<E>
implements RangeIterator<E> {
    private final Collection<E> collection;
    private long index;
    private Iterator<E> iterator;

    CollectionRangeIterator(Collection<E> collection) {
        this.collection = collection;
        this.index = 0L;
        this.iterator = collection.iterator();
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public E next() {
        ++this.index;
        return this.iterator.next();
    }

    public void remove() {
        this.iterator.remove();
    }

    public void skip(long skipNum) {
        long skip = Math.max(0L, Math.min(skipNum, this.getSize()));
        while (skip-- > 0L) {
            this.next();
        }
    }

    public long getSize() {
        return (long)this.collection.size() - this.index;
    }

    public long getPosition() {
        return this.index;
    }
}

