/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import com.day.cq.dam.api.Revision;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.testing.mock.sling.loader.ContentLoader;

class MockAsset
extends ResourceWrapper
implements Asset {
    private final ResourceResolver resourceResolver;
    private final Resource resource;
    private final ValueMap contentProps;
    private final Resource renditionsResource;
    private boolean batchMode;

    MockAsset(Resource resource) {
        super(resource);
        this.resourceResolver = resource.getResourceResolver();
        this.resource = resource;
        Resource contentResource = resource.getChild("jcr:content");
        this.contentProps = ResourceUtil.getValueMap((Resource)contentResource);
        this.renditionsResource = resource.getChild("jcr:content/renditions");
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Resource.class) {
            return (AdapterType)this.resource;
        }
        return (AdapterType)super.adaptTo(type);
    }

    public Map<String, Object> getMetadata() {
        Resource metadataResource = this.resource.getChild("jcr:content/metadata");
        return ResourceUtil.getValueMap((Resource)metadataResource);
    }

    public Object getMetadata(String name) {
        return this.getMetadata().get(name);
    }

    public String getMetadataValue(String name) {
        Object value = this.getMetadata(name);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public long getLastModified() {
        Calendar lastModified = (Calendar)this.contentProps.get("jcr:lastModified", Calendar.class);
        if (lastModified != null) {
            return lastModified.getTimeInMillis();
        }
        return 0L;
    }

    public String getModifier() {
        return (String)this.contentProps.get("jcr:lastModifiedBy", (Object)"");
    }

    public String getMimeType() {
        Rendition original;
        String mimeType = this.getMetadataValue("dc:format");
        if (StringUtils.isBlank((CharSequence)mimeType) && (original = this.getOriginal()) != null) {
            mimeType = original.getMimeType();
        }
        return mimeType;
    }

    public List<Rendition> getRenditions() {
        return Lists.newArrayList(this.listRenditions());
    }

    public Iterator<Rendition> listRenditions() {
        if (this.renditionsResource == null) {
            return ImmutableList.of().iterator();
        }
        Iterator renditionResources = this.resourceResolver.listChildren(this.renditionsResource);
        return ResourceUtil.adaptTo((Iterator)renditionResources, Rendition.class);
    }

    public Rendition getRendition(String name) {
        Iterator<Rendition> renditions = this.listRenditions();
        while (renditions.hasNext()) {
            Rendition rendition = renditions.next();
            if (!StringUtils.equals((CharSequence)rendition.getName(), (CharSequence)name)) continue;
            return rendition;
        }
        return null;
    }

    public Rendition getRendition(RenditionPicker picker) {
        return picker.getRendition((Asset)this);
    }

    public Rendition getOriginal() {
        return this.getRendition("original");
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MockAsset)) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.getPath(), (CharSequence)((MockAsset)((Object)obj)).getPath());
    }

    public Rendition addRendition(String name, InputStream is, String mimeType) {
        if (this.getRendition(name) != null) {
            this.removeRendition(name);
        }
        ContentLoader contentLoader = new ContentLoader(this.resourceResolver, null, false);
        Resource rendition = contentLoader.binaryFile(is, this.renditionsResource.getPath() + "/" + name, mimeType);
        try {
            if (!this.isBatchMode()) {
                this.resourceResolver.commit();
            }
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to remove resource: " + rendition.getPath(), ex);
        }
        return (Rendition)rendition.adaptTo(Rendition.class);
    }

    public void removeRendition(String name) {
        Resource rendition = this.renditionsResource.getChild(name);
        if (rendition != null) {
            try {
                this.resourceResolver.delete(rendition);
                if (!this.isBatchMode()) {
                    this.resourceResolver.commit();
                }
            }
            catch (PersistenceException ex) {
                throw new RuntimeException("Unable to remove resource: " + rendition.getPath(), ex);
            }
        }
    }

    public Resource setRendition(String name, InputStream is, String mimeType) {
        return this.addRendition(name, is, mimeType);
    }

    public Rendition addRendition(String name, InputStream is, Map<String, Object> map) {
        throw new UnsupportedOperationException();
    }

    public Rendition getCurrentOriginal() {
        throw new UnsupportedOperationException();
    }

    public boolean isSubAsset() {
        throw new UnsupportedOperationException();
    }

    public void setCurrentOriginal(String name) {
        throw new UnsupportedOperationException();
    }

    public Revision createRevision(String label, String comment) {
        throw new UnsupportedOperationException();
    }

    public Asset restore(String revisionId) {
        throw new UnsupportedOperationException();
    }

    public Collection<Revision> getRevisions(Calendar cal) {
        throw new UnsupportedOperationException();
    }

    public Asset addSubAsset(String name, String mimeType, InputStream stream) {
        throw new UnsupportedOperationException();
    }

    public Collection<Asset> getSubAssets() {
        throw new UnsupportedOperationException();
    }

    public void setBatchMode(boolean mode) {
        this.batchMode = mode;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public String getID() {
        throw new UnsupportedOperationException();
    }

    public Rendition getImagePreviewRendition() {
        throw new UnsupportedOperationException();
    }

    public String getMetadataValueFromJcr(String arg0) {
        throw new UnsupportedOperationException();
    }

    public void initAssetState() {
        throw new UnsupportedOperationException();
    }
}

