/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.context;

import com.day.cq.dam.api.AssetManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.commons.WCMUtils;
import com.google.common.collect.ImmutableSet;
import io.wcm.testing.mock.aem.MockAemAdapterFactory;
import io.wcm.testing.mock.aem.MockComponentContext;
import io.wcm.testing.mock.aem.MockLayerAdapterFactory;
import io.wcm.testing.mock.aem.builder.ContentBuilder;
import io.wcm.testing.mock.aem.context.ContextResourceResolverFactory;
import io.wcm.testing.mock.aem.context.UniqueRoot;
import java.util.Set;
import javax.servlet.ServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.context.SlingContextImpl;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public class AemContextImpl
extends SlingContextImpl {
    static final Set<String> DEFAULT_RUN_MODES = ImmutableSet.builder().add((Object)"publish").build();

    protected void registerDefaultServices() {
        super.registerDefaultServices();
        this.registerInjectActivateService(new MockAemAdapterFactory());
        this.registerInjectActivateService(new MockLayerAdapterFactory());
    }

    protected void setResourceResolverType(ResourceResolverType resourceResolverType) {
        super.setResourceResolverType(resourceResolverType);
    }

    protected ResourceResolverFactory newResourceResolverFactory() {
        return ContextResourceResolverFactory.get(this.resourceResolverType, this.bundleContext());
    }

    protected void setUp() {
        super.setUp();
    }

    protected void tearDown() {
        super.tearDown();
    }

    public PageManager pageManager() {
        return (PageManager)this.resourceResolver().adaptTo(PageManager.class);
    }

    public AssetManager assetManager() {
        return (AssetManager)this.resourceResolver().adaptTo(AssetManager.class);
    }

    public ContentBuilder create() {
        if (this.contentBuilder == null) {
            this.contentBuilder = new ContentBuilder(this.resourceResolver());
        }
        return (ContentBuilder)this.contentBuilder;
    }

    public Page currentPage() {
        ComponentContext context = WCMUtils.getComponentContext((ServletRequest)this.request());
        if (context != null) {
            return context.getPage();
        }
        if (this.currentResource() != null) {
            return this.pageManager().getContainingPage(this.currentResource());
        }
        return null;
    }

    public Page currentPage(String pagePath) {
        if (pagePath != null) {
            Page page = this.pageManager().getPage(pagePath);
            if (page == null) {
                throw new IllegalArgumentException("Page does not exist: " + pagePath);
            }
            return this.currentPage(page);
        }
        this.currentPage((Page)null);
        return null;
    }

    public Page currentPage(Page page) {
        if (page != null) {
            MockComponentContext wcmComponentContext = new MockComponentContext(page, (SlingHttpServletRequest)this.request());
            this.request.setAttribute("com.day.cq.wcm.componentcontext", (Object)wcmComponentContext);
            this.currentResource(page.getContentResource());
            return page;
        }
        this.request.setAttribute("com.day.cq.wcm.componentcontext", null);
        this.currentResource(null);
        return null;
    }

    public UniqueRoot uniqueRoot() {
        if (this.uniqueRoot == null) {
            this.uniqueRoot = new UniqueRoot(this);
        }
        return (UniqueRoot)this.uniqueRoot;
    }
}

