/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.junit;

import com.google.common.collect.ImmutableList;
import io.wcm.testing.junit.rules.parameterized.Callback;
import io.wcm.testing.junit.rules.parameterized.ListGenerator;
import io.wcm.testing.mock.aem.context.AemContextImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.context.ContextCallback;
import org.apache.sling.testing.mock.osgi.context.ContextPlugins;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.apache.sling.testing.mock.sling.MockSling;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.junit.rules.ExternalResource;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class AemContext
extends AemContextImpl
implements TestRule {
    private final ContextPlugins plugins;
    private final ResourceResolverType[] resourceResolverTypes;
    private final TestRule delegate;

    public AemContext(ResourceResolverType ... resourceResolverTypes) {
        this(new ContextPlugins(), null, resourceResolverTypes);
    }

    public <T extends OsgiContextImpl> AemContext(ContextCallback<T> afterSetUpCallback, ResourceResolverType ... resourceResolverTypes) {
        this(new ContextPlugins(afterSetUpCallback), null, resourceResolverTypes);
    }

    public <U extends OsgiContextImpl, V extends OsgiContextImpl> AemContext(ContextCallback<U> afterSetUpCallback, ContextCallback<V> beforeTearDownCallback, ResourceResolverType ... resourceResolverTypes) {
        this(new ContextPlugins(afterSetUpCallback, beforeTearDownCallback), null, resourceResolverTypes);
    }

    AemContext(ContextPlugins contextPlugins, Map<String, Object> resourceResolverFactoryActivatorProps, ResourceResolverType ... resourceResolverTypes) {
        this.plugins = contextPlugins;
        Map<String, Object> mergedProps = this.resourceResolverFactoryActivatorPropsMergeWithAemDefault(resourceResolverFactoryActivatorProps);
        this.setResourceResolverFactoryActivatorProps(mergedProps);
        this.resourceResolverTypes = resourceResolverTypes == null || resourceResolverTypes.length == 0 ? new ResourceResolverType[]{MockSling.DEFAULT_RESOURCERESOLVER_TYPE} : resourceResolverTypes;
        if (this.resourceResolverTypes.length == 1) {
            this.setResourceResolverType(this.resourceResolverTypes[0]);
            this.delegate = new ExternalResource(){

                protected void before() {
                    AemContext.this.plugins.executeBeforeSetUpCallback((OsgiContextImpl)AemContext.this);
                    AemContext.this.setUp();
                    AemContext.this.plugins.executeAfterSetUpCallback((OsgiContextImpl)AemContext.this);
                }

                protected void after() {
                    AemContext.this.plugins.executeBeforeTearDownCallback((OsgiContextImpl)AemContext.this);
                    AemContext.this.tearDown();
                    AemContext.this.plugins.executeAfterTearDownCallback((OsgiContextImpl)AemContext.this);
                }
            };
        } else {
            Callback<ResourceResolverType> parameterizedSetUpCallback = new Callback<ResourceResolverType>(){

                public void execute(ResourceResolverType currrentValue) {
                    AemContext.this.setResourceResolverType(currrentValue);
                    AemContext.this.plugins.executeBeforeSetUpCallback((OsgiContextImpl)AemContext.this);
                    AemContext.this.setUp();
                    AemContext.this.plugins.executeAfterSetUpCallback((OsgiContextImpl)AemContext.this);
                }
            };
            Callback<ResourceResolverType> parameterizedTearDownCallback = new Callback<ResourceResolverType>(){

                public void execute(ResourceResolverType currrentValue) {
                    AemContext.this.plugins.executeBeforeTearDownCallback((OsgiContextImpl)AemContext.this);
                    AemContext.this.tearDown();
                    AemContext.this.plugins.executeAfterTearDownCallback((OsgiContextImpl)AemContext.this);
                }
            };
            this.delegate = new ListGenerator((List)ImmutableList.copyOf((Object[])this.resourceResolverTypes), (Callback)parameterizedSetUpCallback, (Callback)parameterizedTearDownCallback);
        }
    }

    private Map<String, Object> resourceResolverFactoryActivatorPropsMergeWithAemDefault(Map<String, Object> customProps) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("resource.resolver.searchpath", new String[]{"/apps", "/libs", "/apps/foundation/components/primary", "/libs/foundation/components/primary"});
        props.put("resource.resolver.manglenamespaces", true);
        props.put("resource.resolver.allowDirect", true);
        props.put("resource.resolver.virtual", new String[]{"/:/"});
        props.put("resource.resolver.mapping", new String[]{"/-/"});
        props.put("resource.resolver.map.location", "/etc/map");
        props.put("resource.resolver.default.vanity.redirect.status", "");
        props.put("resource.resolver.virtual", "302");
        props.put("resource.resolver.enable.vanitypath", false);
        props.put("resource.resolver.vanitypath.maxEntries", -1);
        props.put("resource.resolver.vanitypath.bloomfilter.maxBytes", 1024000);
        props.put("resource.resolver.optimize.alias.resolution", true);
        props.put("resource.resolver.vanitypath.whitelist", new String[]{"/apps/", "/libs/", "/content/"});
        props.put("resource.resolver.vanitypath.blacklist", new String[]{"/content/usergenerated"});
        props.put("resource.resolver.vanity.precedence", false);
        props.put("resource.resolver.providerhandling.paranoid", false);
        if (customProps != null) {
            props.putAll(customProps);
        }
        return props;
    }

    public Statement apply(Statement base, Description description) {
        return this.delegate.apply(base, description);
    }
}

