/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.junit.rules.parameterized;

import io.wcm.testing.junit.rules.parameterized.AccessibleErrorCollector;
import io.wcm.testing.junit.rules.parameterized.Callback;
import io.wcm.testing.junit.rules.parameterized.Generator;
import io.wcm.testing.junit.rules.parameterized.RepeatedStatement;
import io.wcm.testing.junit.rules.parameterized.SyncingIterable;
import io.wcm.testing.junit.rules.parameterized.ValueContainer;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class ListGenerator<T>
implements Generator<T> {
    private final ValueContainer<T> currentValue = new ValueContainer();
    private final AccessibleErrorCollector errorCollector = new AccessibleErrorCollector();
    private final List<T> values;
    private final Callback<T> setUpCallback;
    private final Callback<T> tearDownCallback;

    public ListGenerator(List<T> values) {
        this(values, null, null);
    }

    public ListGenerator(List<T> values, Callback<T> setUpCallback, Callback<T> tearDownCallback) {
        this.values = values;
        this.setUpCallback = setUpCallback;
        this.tearDownCallback = tearDownCallback;
    }

    @Override
    public T value() {
        return this.currentValue.get();
    }

    public Statement apply(Statement test, Description description) {
        return new RepeatedStatement<T>(test, new SyncingIterable<T>(this.values, this.currentValue), this.errorCollector, this.setUpCallback, this.tearDownCallback);
    }
}

