/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.junit.rules.parameterized;

import io.wcm.testing.junit.rules.parameterized.AccessibleErrorCollector;
import io.wcm.testing.junit.rules.parameterized.Callback;
import org.junit.runners.model.Statement;

class RepeatedStatement<T>
extends Statement {
    private final Statement test;
    private final Iterable<T> values;
    private final AccessibleErrorCollector errorCollector;
    private final Callback<T> setUpCallback;
    private final Callback<T> tearDownCallback;

    public RepeatedStatement(Statement test, Iterable<T> values, AccessibleErrorCollector errorCollector, Callback<T> setUpCallback, Callback<T> tearDownCallback) {
        this.test = test;
        this.values = values;
        this.errorCollector = errorCollector;
        this.setUpCallback = setUpCallback;
        this.tearDownCallback = tearDownCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        for (T v : this.values) {
            try {
                if (this.setUpCallback != null) {
                    this.setUpCallback.execute(v);
                }
                this.test.evaluate();
            }
            catch (Throwable ex) {
                this.errorCollector.addError((Throwable)((Object)new AssertionError(RepeatedStatement.buildAssertionMessage("For value " + v, ex), ex)));
            }
            finally {
                try {
                    if (this.tearDownCallback == null) continue;
                    this.tearDownCallback.execute(v);
                }
                catch (Throwable ex) {
                    this.errorCollector.addError((Throwable)((Object)new AssertionError(RepeatedStatement.buildAssertionMessage("For value " + v + " (teardown)", ex), ex)));
                }
            }
        }
        this.errorCollector.verify();
    }

    private static String buildAssertionMessage(String msg, Throwable ex) {
        StringBuilder sb = new StringBuilder();
        sb.append(msg);
        sb.append(": ");
        if (ex.getMessage() != null) {
            sb.append(ex.getMessage());
        } else {
            sb.append(ex.getClass().getName());
        }
        return sb.toString();
    }
}

