/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.junit.rules.parameterized;

import io.wcm.testing.junit.rules.parameterized.ValueContainer;
import java.util.Iterator;

class SyncingIterable<T>
implements Iterable<T> {
    private final Iterable<T> values;
    private final ValueContainer<T> valueContainer;

    public SyncingIterable(Iterable<T> values, ValueContainer<T> valueContainer) {
        this.values = values;
        this.valueContainer = valueContainer;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Iterator<T> delegate;
            {
                this.delegate = SyncingIterable.this.values.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public T next() {
                Object next = this.delegate.next();
                SyncingIterable.this.valueContainer.set(next);
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove from this iterator");
            }
        };
    }
}

