/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.commons.caching;

import com.day.cq.wcm.api.WCMMode;
import io.wcm.wcm.commons.caching.ModificationDateProvider;
import io.wcm.wcm.commons.caching.ResourceModificationDateProvider;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public final class CacheHeader {
    private static final Logger log = LoggerFactory.getLogger(CacheHeader.class);
    private static final String RFC_1123_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    static final String HEADER_LAST_MODIFIED = "Last-Modified";
    static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    static final String HEADER_PRAGMA = "Pragma";
    static final String HEADER_CACHE_CONTROL = "Cache-Control";
    static final String HEADER_EXPIRES = "Expires";
    static final String HEADER_DISPATCHER = "Dispatcher";
    static final String NO_CACHE = "no-cache";
    private static final DateFormat RFC1123_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);

    private CacheHeader() {
    }

    static synchronized String formatDate(Date pDate) {
        return RFC1123_DATE_FORMAT.format(pDate);
    }

    static synchronized Date parseDate(String pDateString) throws ParseException {
        return RFC1123_DATE_FORMAT.parse(pDateString);
    }

    public static boolean isNotModified(@NotNull Resource resource, @NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) {
        ResourceModificationDateProvider dateProvider = new ResourceModificationDateProvider(resource);
        return CacheHeader.isNotModified(dateProvider, request, response);
    }

    public static boolean isNotModified(@NotNull Resource resource, @NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, boolean setExpiresHeader) {
        ResourceModificationDateProvider dateProvider = new ResourceModificationDateProvider(resource);
        return CacheHeader.isNotModified(dateProvider, request, response, setExpiresHeader);
    }

    public static boolean isNotModified(@NotNull ModificationDateProvider dateProvider, @NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) {
        boolean isAuthor = WCMMode.fromRequest((ServletRequest)request) != WCMMode.DISABLED;
        return CacheHeader.isNotModified(dateProvider, request, response, isAuthor);
    }

    public static boolean isNotModified(@NotNull ModificationDateProvider dateProvider, @NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, boolean setExpiresHeader) {
        boolean isModified = true;
        Date lastModificationDate = dateProvider.getModificationDate();
        String ifModifiedSince = request.getHeader(HEADER_IF_MODIFIED_SINCE);
        if (lastModificationDate != null && StringUtils.isNotBlank((CharSequence)ifModifiedSince)) {
            try {
                Date clientModificationDate = CacheHeader.parseDate(ifModifiedSince);
                isModified = lastModificationDate.getTime() - 1000L > clientModificationDate.getTime();
            }
            catch (ParseException ex) {
                log.warn("Failed to parse value '{}' of If-Modified-Since header.", (Object)ifModifiedSince, (Object)ex);
            }
        }
        if (!isModified) {
            response.setStatus(304);
            return true;
        }
        if (lastModificationDate != null) {
            response.setHeader(HEADER_LAST_MODIFIED, CacheHeader.formatDate(lastModificationDate));
            if (setExpiresHeader) {
                response.setHeader(HEADER_EXPIRES, "-1");
            }
        }
        return false;
    }

    public static void setNonCachingHeaders(@NotNull HttpServletResponse response) {
        response.setHeader(HEADER_PRAGMA, NO_CACHE);
        response.setHeader(HEADER_CACHE_CONTROL, NO_CACHE);
        response.setHeader(HEADER_EXPIRES, "0");
        response.setHeader(HEADER_DISPATCHER, NO_CACHE);
    }

    public static void setExpires(@NotNull HttpServletResponse response, @Nullable Date date) {
        if (date == null) {
            response.setHeader(HEADER_EXPIRES, "-1");
        } else {
            response.setHeader(HEADER_EXPIRES, CacheHeader.formatDate(date));
        }
    }

    public static void setExpiresSeconds(@NotNull HttpServletResponse response, int seconds) {
        Date expiresDate = DateUtils.addSeconds((Date)new Date(), (int)seconds);
        CacheHeader.setExpires(response, expiresDate);
    }

    public static void setExpiresHours(@NotNull HttpServletResponse response, int hours) {
        Date expiresDate = DateUtils.addHours((Date)new Date(), (int)hours);
        CacheHeader.setExpires(response, expiresDate);
    }

    public static void setExpiresDays(@NotNull HttpServletResponse response, int days) {
        Date expiresDate = DateUtils.addDays((Date)new Date(), (int)days);
        CacheHeader.setExpires(response, expiresDate);
    }

    static {
        RFC1123_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

