/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.commons.instancetype.impl;

import com.day.cq.wcm.api.WCMMode;
import io.wcm.wcm.commons.instancetype.InstanceTypeService;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={InstanceTypeService.class})
@Designate(ocd=Config.class)
public class InstanceTypeServiceImpl
implements InstanceTypeService {
    static final String TYPE_AUTO = "auto";
    static final String WCM_REQUEST_FILTER_PID = "com.day.cq.wcm.core.WCMRequestFilter";
    static final String WCM_MODE_PROPERTY = "wcmfilter.mode";
    private boolean isAuthor;
    private Set<String> runModes;
    @Reference
    private ConfigurationAdmin configAdmin;
    private final Logger log = LoggerFactory.getLogger(InstanceTypeServiceImpl.class);

    @Activate
    private void activate(Config config) {
        String instanceType = config.instance_type();
        if (StringUtils.equals((CharSequence)instanceType, (CharSequence)"author")) {
            this.isAuthor = true;
        } else if (StringUtils.equals((CharSequence)instanceType, (CharSequence)"publish")) {
            this.isAuthor = false;
        } else {
            this.isAuthor = this.detectAutorMode();
            this.log.warn("Please provide a 'wcm.io Commons AEM Instance Type' configuration - falling back to guessing instance type from other configuration => {}.", (Object)(this.isAuthor ? "author" : "publish"));
        }
        this.runModes = this.isAuthor ? Collections.singleton("author") : Collections.singleton("publish");
    }

    private boolean detectAutorMode() {
        try {
            Object defaultWcmMode;
            Configuration[] configs = this.configAdmin.listConfigurations("(service.pid=com.day.cq.wcm.core.WCMRequestFilter)");
            if (configs != null && configs.length > 0 && (defaultWcmMode = configs[0].getProperties().get(WCM_MODE_PROPERTY)) instanceof String) {
                return !StringUtils.equalsIgnoreCase((CharSequence)WCMMode.DISABLED.name(), (CharSequence)((String)defaultWcmMode));
            }
        }
        catch (IOException | InvalidSyntaxException ex) {
            this.log.warn("Unable to read OSGi configuration: {}", (Object)WCM_REQUEST_FILTER_PID, (Object)ex);
        }
        return false;
    }

    @Override
    public boolean isAuthor() {
        return this.isAuthor;
    }

    @Override
    public boolean isPublish() {
        return !this.isAuthor;
    }

    @Override
    @NotNull
    public Set<String> getRunModes() {
        return Collections.unmodifiableSet(this.runModes);
    }

    @ObjectClassDefinition(name="wcm.io Commons AEM Instance Type", description="Configures if the current instance is an author or publish instance, and makes this information accessible for other services.")
    static @interface Config {
        @AttributeDefinition(name="Instance Type", description="Should be explicitely configured to 'author' or 'publish'. If not set, instance type will be guessed by heuristics from other OSGi configurations.", options={@Option(value="author", label="Author"), @Option(value="publish", label="Publish"), @Option(value="auto", label="Detect automatically (not recommended)")})
        public String instance_type() default "auto";
    }
}

