/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.commons.util;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.components.ComponentContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;

public final class EditableTemplate {
    static final String NN_EDITABLE_TEMPLATE_INITIAL = "initial";
    static final String NN_EDITABLE_TEMPLATE_STRUCTURE = "structure";
    static final String NN_EDITABLE_TEMPLATE_POLICIES = "policies";
    static final String PN_EDITABLE = "editable";

    private EditableTemplate() {
    }

    public static boolean isEditRestricted(@NotNull ComponentContext wcmComponentContext) {
        Page page = wcmComponentContext.getPage();
        if (page == null) {
            return false;
        }
        ResourceResolver resourceResolver = wcmComponentContext.getResource().getResourceResolver();
        Template template = page.getTemplate();
        if (template == null || EditableTemplate.isPageInTemplateDefinition(page) || !EditableTemplate.isEditableTemplate(template)) {
            return false;
        }
        String resourcePath = wcmComponentContext.getResource().getPath();
        String templateStructurePath = template.getPath() + "/structure/jcr:content";
        Object resourcePathInStructure = null;
        if (StringUtils.startsWith((CharSequence)resourcePath, (CharSequence)(templateStructurePath + "/"))) {
            resourcePathInStructure = resourcePath;
        } else {
            String relativePathInPage = StringUtils.substringAfter((String)resourcePath, (String)page.getContentResource().getPath());
            if (StringUtils.isNotEmpty((CharSequence)relativePathInPage)) {
                resourcePathInStructure = templateStructurePath + relativePathInPage;
            }
        }
        if (resourcePathInStructure == null) {
            return false;
        }
        Resource resourceInStructure = resourceResolver.getResource((String)resourcePathInStructure);
        if (resourceInStructure == null) {
            return false;
        }
        return (Boolean)resourceInStructure.getValueMap().get(PN_EDITABLE, (Object)false) == false;
    }

    private static boolean isEditableTemplate(@NotNull Template template) {
        Resource resource = (Resource)template.adaptTo(Resource.class);
        if (resource != null) {
            return resource.getChild(NN_EDITABLE_TEMPLATE_INITIAL) != null && resource.getChild(NN_EDITABLE_TEMPLATE_STRUCTURE) != null && resource.getChild(NN_EDITABLE_TEMPLATE_POLICIES) != null;
        }
        return false;
    }

    private static boolean isPageInTemplateDefinition(Page page) {
        Resource parent;
        Resource resource = (Resource)page.adaptTo(Resource.class);
        if (resource != null && (parent = resource.getParent()) != null) {
            return StringUtils.equals((CharSequence)"cq:Template", (CharSequence)((CharSequence)parent.getValueMap().get("jcr:primaryType", String.class)));
        }
        return false;
    }
}

