/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.commons.util;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;

@ProviderType
public final class RunMode {
    public static final String AUTHOR = "author";
    public static final String PUBLISH = "publish";

    private RunMode() {
    }

    @Deprecated(since="1.0.4")
    public static boolean is(Set<String> runModes, String ... expectedRunModes) {
        if (runModes != null && expectedRunModes != null) {
            for (String expectedRunMode : expectedRunModes) {
                if (expectedRunMode == null || !runModes.contains(expectedRunMode)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated(since="1.0.4")
    public static boolean isAuthor(Set<String> runModes) {
        return RunMode.is(runModes, AUTHOR);
    }

    @Deprecated(since="1.0.4")
    public static boolean isPublish(Set<String> runModes) {
        return RunMode.is(runModes, PUBLISH);
    }

    @Deprecated(since="1.0.4")
    public static boolean disableIfNoRunModeActive(Set<String> runModes, String[] allowedRunModes, ComponentContext componentContext, Logger log) {
        String name = (String)componentContext.getProperties().get("component.name");
        boolean result = false;
        boolean isActive = false;
        for (String runMode : allowedRunModes) {
            if (!runModes.contains(runMode)) continue;
            isActive = true;
            break;
        }
        if (!isActive) {
            if (log.isDebugEnabled()) {
                log.debug("Component '{}' disabled as none of its run modes ({}) are currently active ({}).", new Object[]{name, StringUtils.join((Object[])allowedRunModes, (String)","), StringUtils.join(runModes, (String)",")});
            }
            componentContext.disableComponent(name);
            result = true;
        } else if (log.isDebugEnabled()) {
            log.debug("Component '{}' enabled as at least one of its run modes ({}) are currently active ({}).", new Object[]{name, StringUtils.join((Object[])allowedRunModes, (String)","), StringUtils.join(runModes, (String)",")});
        }
        return result;
    }

    @Deprecated(since="1.0.4")
    public static boolean disableIfNotAuthor(Set<String> runModes, ComponentContext componentContext, Logger log) {
        return RunMode.disableIfNoRunModeActive(runModes, new String[]{AUTHOR}, componentContext, log);
    }

    @Deprecated(since="1.0.4")
    public static boolean disableIfNotPublish(Set<String> runModes, ComponentContext componentContext, Logger log) {
        return RunMode.disableIfNoRunModeActive(runModes, new String[]{PUBLISH}, componentContext, log);
    }
}

