/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.commons.bundleinfo.impl;

import io.wcm.wcm.commons.bundleinfo.BundleInfo;
import io.wcm.wcm.commons.bundleinfo.BundleState;
import java.util.Date;
import java.util.Dictionary;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Bundle;

class BundleInfoImpl
implements BundleInfo {
    private final String symbolicName;
    private final Bundle bundle;
    private final Dictionary headers;
    private final BundleState state;

    BundleInfoImpl(Bundle bundle) {
        this.symbolicName = bundle.getSymbolicName();
        this.bundle = bundle;
        this.headers = bundle.getHeaders();
        this.state = this.isFragment() ? BundleState.FRAGMENT : BundleState.valueOf(bundle.getState());
    }

    @Override
    @NotNull
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    @NotNull
    public String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    @NotNull
    public String getName() {
        return StringUtils.defaultString((String)((String)this.headers.get("Bundle-Name")), (String)this.getSymbolicName());
    }

    @Override
    @NotNull
    public String getVersion() {
        return StringUtils.defaultString((String)((String)this.headers.get("Bundle-Version")));
    }

    @Override
    @NotNull
    public BundleState getState() {
        return this.state;
    }

    @Override
    @Nullable
    public Date getLastModified() {
        if (this.bundle.getLastModified() == 0L) {
            return null;
        }
        return new Date(this.bundle.getLastModified());
    }

    @Override
    public boolean isFragment() {
        String fragmentHost = (String)this.headers.get("Fragment-Host");
        return StringUtils.isNotBlank((CharSequence)fragmentHost);
    }

    public String toString() {
        return this.symbolicName;
    }

    public int hashCode() {
        return this.symbolicName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BundleInfoImpl)) {
            return false;
        }
        BundleInfoImpl other = (BundleInfoImpl)obj;
        return this.symbolicName.equals(other.symbolicName);
    }

    @Override
    public int compareTo(BundleInfo obj) {
        return this.getSymbolicName().compareTo(obj.getSymbolicName());
    }
}

