/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.commons.component;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.ComponentManager;
import com.day.cq.wcm.api.policies.ContentPolicy;
import com.day.cq.wcm.api.policies.ContentPolicyManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.wcm.sling.commons.adapter.AdaptTo;
import io.wcm.wcm.commons.component.ComponentPropertyResolution;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public final class ComponentPropertyResolver
implements AutoCloseable {
    private ComponentPropertyResolution componentPropertiesResolution = ComponentPropertyResolution.RESOLVE_INHERIT;
    private ComponentPropertyResolution pagePropertiesResolution = ComponentPropertyResolution.IGNORE;
    private ComponentPropertyResolution contentPolicyResolution = ComponentPropertyResolution.IGNORE;
    private final Page currentPage;
    private final Component currentComponent;
    private final Resource resource;
    private final ResourceResolverFactory resourceResolverFactory;
    private ResourceResolver componentsResourceResolver;
    private boolean initComponentsResourceResolverFailed;
    private static final String SERVICEUSER_SUBSERVICE = "component-properties";
    private static final Logger log = LoggerFactory.getLogger(ComponentPropertyResolver.class);

    public ComponentPropertyResolver(@NotNull Page page, @Nullable ResourceResolverFactory resourceResolverFactory) {
        this(page.getContentResource(), resourceResolverFactory);
    }

    public ComponentPropertyResolver(@NotNull Resource resource, @Nullable ResourceResolverFactory resourceResolverFactory) {
        this(resource, false, resourceResolverFactory);
    }

    public ComponentPropertyResolver(@NotNull Resource resource, boolean ensureResourceType, @Nullable ResourceResolverFactory resourceResolverFactory) {
        Resource contextResource = null;
        if (ensureResourceType) {
            contextResource = ComponentPropertyResolver.getResourceWithResourceType(resource);
        }
        if (contextResource == null) {
            contextResource = resource;
        }
        ResourceResolver resourceResolver = contextResource.getResourceResolver();
        PageManager pageManager = (PageManager)AdaptTo.notNull((Adaptable)resourceResolver, PageManager.class);
        this.currentPage = pageManager.getContainingPage(contextResource);
        if (ComponentPropertyResolver.hasResourceType(contextResource)) {
            ComponentManager componentManager = (ComponentManager)AdaptTo.notNull((Adaptable)resourceResolver, ComponentManager.class);
            this.currentComponent = componentManager.getComponentOfResource(contextResource);
        } else {
            this.currentComponent = null;
        }
        this.resource = contextResource;
        this.resourceResolverFactory = resourceResolverFactory;
    }

    public ComponentPropertyResolver(@NotNull ComponentContext wcmComponentContext, @Nullable ResourceResolverFactory resourceResolverFactory) {
        this.currentPage = wcmComponentContext.getPage();
        this.currentComponent = wcmComponentContext.getComponent();
        this.resource = wcmComponentContext.getResource();
        this.resourceResolverFactory = resourceResolverFactory;
    }

    @Deprecated
    public ComponentPropertyResolver(@NotNull Page page) {
        this(page, null);
    }

    @Deprecated
    public ComponentPropertyResolver(@NotNull Resource resource) {
        this(resource, null);
    }

    @Deprecated
    public ComponentPropertyResolver(@NotNull Resource resource, boolean ensureResourceType) {
        this(resource, ensureResourceType, null);
    }

    @Deprecated
    public ComponentPropertyResolver(@NotNull ComponentContext wcmComponentContext) {
        this(wcmComponentContext, null);
    }

    private static boolean hasResourceType(@NotNull Resource resource) {
        return StringUtils.isNotEmpty((CharSequence)resource.getResourceType());
    }

    @Nullable
    private static Resource getResourceWithResourceType(@Nullable Resource resource) {
        if (resource == null) {
            return null;
        }
        String resourceType = resource.getResourceType();
        if (resourceType != null && ComponentPropertyResolver.isPathBasedResourceType(resourceType)) {
            return resource;
        }
        return ComponentPropertyResolver.getResourceWithResourceType(resource.getParent());
    }

    private static boolean isPathBasedResourceType(@NotNull String resourceType) {
        return StringUtils.contains((CharSequence)resourceType, (CharSequence)"/");
    }

    public ComponentPropertyResolver componentPropertiesResolution(@NotNull ComponentPropertyResolution resolution) {
        this.componentPropertiesResolution = resolution;
        return this;
    }

    public ComponentPropertyResolver pagePropertiesResolution(@NotNull ComponentPropertyResolution resolution) {
        this.pagePropertiesResolution = resolution;
        return this;
    }

    public ComponentPropertyResolver contentPolicyResolution(@NotNull ComponentPropertyResolution resolution) {
        this.contentPolicyResolution = resolution;
        return this;
    }

    @Nullable
    public <T> T get(@NotNull String name, @NotNull Class<T> type) {
        @Nullable T value = this.getPageProperty(this.currentPage, name, type);
        if (value == null) {
            value = this.getContentPolicyProperty(name, type);
        }
        if (value == null) {
            value = this.getComponentProperty(this.currentComponent, name, type);
        }
        return value;
    }

    @NotNull
    public <T> T get(@NotNull String name, @NotNull T defaultValue) {
        @Nullable Class<?> value = this.get(name, (T)defaultValue.getClass());
        if (value != null) {
            return (T)value;
        }
        return defaultValue;
    }

    @Nullable
    private <T> T getComponentProperty(@Nullable Component component, @NotNull String name, @NotNull Class<T> type) {
        Object result;
        if (this.componentPropertiesResolution == ComponentPropertyResolution.IGNORE || component == null) {
            return null;
        }
        if (StringUtils.contains((CharSequence)name, (CharSequence)"/")) {
            String childResourcePath = StringUtils.substringBeforeLast((String)name, (String)"/");
            String localPropertyName = StringUtils.substringAfterLast((String)name, (String)"/");
            Resource childResource = this.getLocalComponentResource(component, childResourcePath);
            result = ResourceUtil.getValueMap((Resource)childResource).get(localPropertyName, type);
        } else {
            result = component.getProperties().get(name, type);
        }
        if (result == null && this.componentPropertiesResolution == ComponentPropertyResolution.RESOLVE_INHERIT) {
            result = this.getComponentProperty(component.getSuperComponent(), name, type);
        }
        return (T)result;
    }

    @Nullable
    private <T> T getPageProperty(@Nullable Page page, @NotNull String name, @NotNull Class<T> type) {
        if (this.pagePropertiesResolution == ComponentPropertyResolution.IGNORE || page == null) {
            return null;
        }
        @Nullable Object result = page.getProperties().get(name, type);
        if (result == null && this.pagePropertiesResolution == ComponentPropertyResolution.RESOLVE_INHERIT) {
            result = this.getPageProperty(page.getParent(), name, type);
        }
        return (T)result;
    }

    @Nullable
    private <T> T getContentPolicyProperty(@NotNull String name, @NotNull Class<T> type) {
        if (this.contentPolicyResolution == ComponentPropertyResolution.IGNORE || this.resource == null) {
            return null;
        }
        ContentPolicy policy = ComponentPropertyResolver.getPolicy(this.resource);
        if (policy != null) {
            return (T)policy.getProperties().get(name, type);
        }
        return null;
    }

    @Nullable
    public Collection<Resource> getResources(@NotNull String name) {
        Collection<Resource> list = this.getPageResources(this.currentPage, name);
        if (list == null) {
            list = this.getContentPolicyResources(name);
        }
        if (list == null) {
            list = this.getComponentResources(this.currentComponent, name);
        }
        return list;
    }

    @Nullable
    private Collection<Resource> getComponentResources(@Nullable Component component, @NotNull String name) {
        if (this.componentPropertiesResolution == ComponentPropertyResolution.IGNORE || component == null) {
            return null;
        }
        Collection<Resource> result = this.getResources(this.getLocalComponentResource(component, name));
        if (result == null && this.componentPropertiesResolution == ComponentPropertyResolution.RESOLVE_INHERIT) {
            result = this.getComponentResources(component.getSuperComponent(), name);
        }
        return result;
    }

    @Nullable
    private Collection<Resource> getPageResources(@Nullable Page page, @NotNull String name) {
        if (this.pagePropertiesResolution == ComponentPropertyResolution.IGNORE || page == null) {
            return null;
        }
        Collection<Resource> result = this.getResources(page.getContentResource(name));
        if (result == null && this.pagePropertiesResolution == ComponentPropertyResolution.RESOLVE_INHERIT) {
            result = this.getPageResources(page.getParent(), name);
        }
        return result;
    }

    @Nullable
    private Collection<Resource> getContentPolicyResources(@NotNull String name) {
        Resource policyResource;
        if (this.contentPolicyResolution == ComponentPropertyResolution.IGNORE || this.resource == null) {
            return null;
        }
        ContentPolicy policy = ComponentPropertyResolver.getPolicy(this.resource);
        if (policy != null && (policyResource = (Resource)policy.adaptTo(Resource.class)) != null) {
            return this.getResources(policyResource.getChild(name));
        }
        return null;
    }

    @Nullable
    private Collection<Resource> getResources(@Nullable Resource parent) {
        if (parent == null) {
            return null;
        }
        ImmutableList children = ImmutableList.copyOf((Iterable)parent.getChildren());
        if (children.isEmpty()) {
            return null;
        }
        return children;
    }

    @Nullable
    private static ContentPolicy getPolicy(@NotNull Resource resource) {
        ContentPolicyManager policyManager = (ContentPolicyManager)AdaptTo.notNull((Adaptable)resource.getResourceResolver(), ContentPolicyManager.class);
        return policyManager.getPolicy(resource);
    }

    @Nullable
    private Resource getLocalComponentResource(@NotNull Component component, @NotNull String childResourcePath) {
        block4: {
            if (this.componentsResourceResolver == null && this.resourceResolverFactory != null && !this.initComponentsResourceResolverFailed) {
                try {
                    this.componentsResourceResolver = this.resourceResolverFactory.getServiceResourceResolver((Map)ImmutableMap.of((Object)"sling.service.subservice", (Object)SERVICEUSER_SUBSERVICE));
                }
                catch (LoginException ex) {
                    this.initComponentsResourceResolverFailed = true;
                    if (!log.isDebugEnabled()) break block4;
                    log.debug("Unable to get resource resolver for accessing local component resource, please make sure to grant access to system user 'sling-scripting' for bundle 'io.wcm.wcm.commons', subservice '{}'.", (Object)SERVICEUSER_SUBSERVICE, (Object)ex);
                }
            }
        }
        if (this.componentsResourceResolver != null) {
            String resourcePath = component.getPath() + "/" + childResourcePath;
            return this.componentsResourceResolver.getResource(resourcePath);
        }
        return component.getLocalResource(childResourcePath);
    }

    @Override
    public void close() {
        if (this.componentsResourceResolver != null) {
            this.componentsResourceResolver.close();
        }
    }
}

