/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.commons.controller;

import com.day.cq.wcm.api.Page;
import io.wcm.sling.models.annotations.AemObject;
import io.wcm.wcm.commons.bundleinfo.BundleInfo;
import io.wcm.wcm.commons.bundleinfo.BundleInfoService;
import io.wcm.wcm.commons.component.ComponentPropertyResolution;
import io.wcm.wcm.commons.component.ComponentPropertyResolver;
import io.wcm.wcm.commons.component.ComponentPropertyResolverFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
@ProviderType
public final class VersionInfo {
    public static final String PN_FILTER_REGEX = "wcmio:versionInfoBundleSymbolicNameRegex";
    @OSGiService
    private BundleInfoService bundleInfoService;
    @OSGiService
    private ComponentPropertyResolverFactory componentPropertyResolverFactory;
    @AemObject
    private Page currentPage;
    private Collection<BundleInfo> bundles;
    private static final Logger log = LoggerFactory.getLogger(VersionInfo.class);

    @PostConstruct
    private void activate() {
        List<Pattern> filterPatterns = this.toPattern(this.getFilterRegex());
        this.bundles = this.getFilteredBundles(filterPatterns);
    }

    public Collection<BundleInfo> getBundles() {
        return this.bundles;
    }

    private Collection<BundleInfo> getFilteredBundles(List<Pattern> filterPatterns) {
        Collection<BundleInfo> allBundles = this.bundleInfoService.getBundles();
        return allBundles.stream().filter(bundle -> this.matchesFilterPatterns((BundleInfo)bundle, filterPatterns)).collect(Collectors.toList());
    }

    private boolean matchesFilterPatterns(BundleInfo bundle, List<Pattern> filterPatterns) {
        if (filterPatterns.isEmpty()) {
            return true;
        }
        return filterPatterns.stream().filter(pattern -> pattern.matcher(bundle.getSymbolicName()).matches()).findAny().isPresent();
    }

    private Stream<String> getFilterRegex() {
        String[] regex;
        try (ComponentPropertyResolver componentPropertyResolver = this.componentPropertyResolverFactory.get(this.currentPage).componentPropertiesResolution(ComponentPropertyResolution.RESOLVE).pagePropertiesResolution(ComponentPropertyResolution.RESOLVE);){
            regex = (String[])componentPropertyResolver.get(PN_FILTER_REGEX, String[].class);
        }
        if (regex != null) {
            return Arrays.stream(regex);
        }
        return Stream.empty();
    }

    private List<Pattern> toPattern(Stream<String> regex) {
        return regex.map(regExString -> {
            try {
                return Pattern.compile(regExString);
            }
            catch (PatternSyntaxException ex) {
                log.warn("Invalid pattern for version info filtering: {} in {}", new Object[]{regex, this.currentPage.getPath(), ex});
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

