/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.commons.util;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;

@ProviderType
public final class RunMode {
    public static final String AUTHOR = "author";
    public static final String PUBLISH = "publish";

    private RunMode() {
    }

    @Deprecated
    public static boolean is(Set<String> runModes, String ... expectedRunModes) {
        if (runModes != null && expectedRunModes != null) {
            for (String expectedRunMode : expectedRunModes) {
                if (!runModes.contains(expectedRunMode)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean isAuthor(Set<String> runModes) {
        return RunMode.is(runModes, AUTHOR);
    }

    @Deprecated
    public static boolean isPublish(Set<String> runModes) {
        return RunMode.is(runModes, PUBLISH);
    }

    @Deprecated
    public static boolean disableIfNoRunModeActive(Set<String> runModes, String[] allowedRunModes, ComponentContext componentContext, Logger log) {
        String name = (String)componentContext.getProperties().get("component.name");
        boolean result = false;
        boolean isActive = false;
        for (String runMode : allowedRunModes) {
            if (!runModes.contains(runMode)) continue;
            isActive = true;
            break;
        }
        if (!isActive) {
            if (log.isDebugEnabled()) {
                log.debug("Component '" + name + "' disabled as none of its run modes (" + StringUtils.join((Object[])allowedRunModes, (String)",") + ") are currently active (" + StringUtils.join(runModes, (String)",") + ").");
            }
            componentContext.disableComponent(name);
            result = true;
        } else if (log.isDebugEnabled()) {
            log.debug("Component '" + name + "' enabled as at least one of its run modes (" + StringUtils.join((Object[])allowedRunModes, (String)",") + ") are currently active (" + StringUtils.join(runModes, (String)",") + ").");
        }
        return result;
    }

    @Deprecated
    public static boolean disableIfNotAuthor(Set<String> runModes, ComponentContext componentContext, Logger log) {
        return RunMode.disableIfNoRunModeActive(runModes, new String[]{AUTHOR}, componentContext, log);
    }

    @Deprecated
    public static boolean disableIfNotPublish(Set<String> runModes, ComponentContext componentContext, Logger log) {
        return RunMode.disableIfNoRunModeActive(runModes, new String[]{PUBLISH}, componentContext, log);
    }
}

