/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.commons.caching;

import com.day.cq.wcm.api.Page;
import io.wcm.wcm.commons.caching.ModificationDateProvider;
import java.util.Calendar;
import java.util.Date;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class ModificationDate {
    private ModificationDate() {
    }

    @Nullable
    public static Date get(@Nullable Page page) {
        if (page == null) {
            return null;
        }
        Calendar lastModified = page.getLastModified();
        if (lastModified != null) {
            return lastModified.getTime();
        }
        return null;
    }

    @Nullable
    public static Date get(@Nullable Resource resource) {
        if (resource == null) {
            return null;
        }
        ValueMap resourceProperties = resource.getValueMap();
        Date cqModified = (Date)resourceProperties.get("cq:lastModified", Date.class);
        Date resourceModified = ModificationDate.getResourceMetadataModificationTime(resource);
        return ModificationDate.mostRecent(cqModified, resourceModified);
    }

    private static Date getResourceMetadataModificationTime(Resource resource) {
        long modificationTime;
        ResourceMetadata metadata = resource.getResourceMetadata();
        if (metadata != null && (modificationTime = metadata.getModificationTime()) > 0L) {
            return new Date(modificationTime);
        }
        return null;
    }

    @Nullable
    public static Date mostRecent(Resource ... resources) {
        Date[] dates = new Date[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            dates[i] = ModificationDate.get(resources[i]);
        }
        return ModificationDate.mostRecent(dates);
    }

    @Nullable
    public static Date mostRecent(Page ... pages) {
        Date[] dates = new Date[pages.length];
        for (int i = 0; i < pages.length; ++i) {
            dates[i] = ModificationDate.get(pages[i]);
        }
        return ModificationDate.mostRecent(dates);
    }

    @Nullable
    public static Date mostRecent(ModificationDateProvider ... dateProviders) {
        Date[] dates = new Date[dateProviders.length];
        for (int i = 0; i < dateProviders.length; ++i) {
            dates[i] = dateProviders[i].getModificationDate();
        }
        return ModificationDate.mostRecent(dates);
    }

    @Nullable
    public static Date mostRecent(Date ... dates) {
        Date mostRecentDate = null;
        for (Date date : dates) {
            if (date == null || mostRecentDate != null && !date.after(mostRecentDate)) continue;
            mostRecentDate = date;
        }
        return mostRecentDate;
    }
}

