/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.commons.contenttype;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class FileExtension {
    public static final String HTML = "html";
    public static final String HTML_UNCACHED = "htx";
    public static final String JSON = "json";
    public static final String PLAINTEXT = "txt";
    public static final String CSS = "css";
    public static final String JAVASCRIPT = "js";
    public static final String XML = "xml";
    public static final String XHTML = "html";
    public static final String ZIP = "zip";
    public static final String GIF = "gif";
    public static final String JPEG = "jpg";
    public static final String PNG = "png";
    public static final String SWF = "swf";
    public static final String CSV = "csv";
    public static final String PDF = "pdf";
    public static final String SVG = "svg";
    public static final String TIFF = "tif";
    public static final String WEBP = "webp";
    private static final Set<String> IMAGE_FILE_EXTENSIONS = ImmutableSet.of((Object)"gif", (Object)"jpg", (Object)"png", (Object)"jpeg");
    private static final Set<String> FLASH_FILE_EXTENSIONS = ImmutableSet.of((Object)"swf");

    private FileExtension() {
    }

    @Deprecated
    public static boolean isImage(@Nullable String fileExtension) {
        if (StringUtils.isEmpty((CharSequence)fileExtension)) {
            return false;
        }
        return IMAGE_FILE_EXTENSIONS.contains(fileExtension.toLowerCase());
    }

    @Deprecated
    @NotNull
    public static Set<String> getImageFileExtensions() {
        return IMAGE_FILE_EXTENSIONS;
    }

    @Deprecated
    public static boolean isFlash(@Nullable String fileExtension) {
        if (StringUtils.isEmpty((CharSequence)fileExtension)) {
            return false;
        }
        return FLASH_FILE_EXTENSIONS.contains(fileExtension.toLowerCase());
    }

    @Deprecated
    @NotNull
    public static Set<String> getFlashFileExtensions() {
        return FLASH_FILE_EXTENSIONS;
    }
}

