/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.commons.filter;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageFilter;
import io.wcm.wcm.commons.util.TemplatePathInfo;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class TemplatePageFilter
extends PageFilter {
    private final Set<String> allowedTemplatePaths;

    public TemplatePageFilter(TemplatePathInfo ... templates) {
        this(false, false, templates);
    }

    public TemplatePageFilter(boolean includeInvalid, boolean includeHidden, TemplatePathInfo ... templates) {
        super(includeInvalid, includeHidden);
        this.allowedTemplatePaths = Arrays.stream(templates).map(TemplatePathInfo::getTemplatePath).collect(Collectors.toSet());
    }

    public boolean includes(Page page) {
        return super.includes(page) && this.allowedTemplatePaths.contains(page.getProperties().get("cq:template", String.class));
    }
}

