/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.wcm.commons.util;

import com.day.cq.wcm.api.Page;
import io.wcm.wcm.commons.util.TemplatePathInfo;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class Template {
    static final Pattern TEMPLATE_PATH_PATTERN = Pattern.compile("^/(apps|libs)/(.+)/templates(/.*)?/([^/]+)$");

    private Template() {
    }

    @Nullable
    public static String getResourceTypeFromTemplatePath(@NotNull String templatePath) {
        if (templatePath == null) {
            return null;
        }
        String resource = null;
        Matcher matcher = TEMPLATE_PATH_PATTERN.matcher(templatePath);
        if (matcher.matches()) {
            resource = matcher.group(2) + "/components" + StringUtils.defaultString((String)matcher.group(3)) + "/page/" + matcher.group(4);
        }
        return resource;
    }

    public static boolean is(@NotNull Page page, TemplatePathInfo ... templates) {
        if (page == null || templates == null || templates.length == 0) {
            return false;
        }
        String templatePath = (String)page.getProperties().get("cq:template", String.class);
        for (TemplatePathInfo template : templates) {
            if (!template.getTemplatePath().equals(templatePath)) continue;
            return true;
        }
        return false;
    }

    public static boolean is(@NotNull Page page, String ... templatePaths) {
        if (page == null || templatePaths == null || templatePaths.length == 0) {
            return false;
        }
        String templatePath = (String)page.getProperties().get("cq:template", String.class);
        for (String givenTemplatePath : templatePaths) {
            if (!StringUtils.equals((CharSequence)templatePath, (CharSequence)givenTemplatePath)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static TemplatePathInfo forTemplatePath(@NotNull String templatePath, TemplatePathInfo ... templates) {
        if (templatePath == null || templates == null || templates.length == 0) {
            return null;
        }
        for (TemplatePathInfo template : templates) {
            if (!StringUtils.equals((CharSequence)template.getTemplatePath(), (CharSequence)templatePath)) continue;
            return template;
        }
        return null;
    }

    @SafeVarargs
    @Nullable
    public static <E extends Enum<E>> TemplatePathInfo forTemplatePath(@NotNull String templatePath, Class<E> ... templateEnums) {
        if (templatePath == null || templateEnums == null) {
            return null;
        }
        for (Class<E> templateEnum : templateEnums) {
            for (Enum template : EnumSet.allOf(templateEnum)) {
                if (!StringUtils.equals((CharSequence)((TemplatePathInfo)((Object)template)).getTemplatePath(), (CharSequence)templatePath)) continue;
                return (TemplatePathInfo)((Object)template);
            }
        }
        return null;
    }

    @Nullable
    public static TemplatePathInfo forPage(@NotNull Page page, TemplatePathInfo ... templates) {
        if (page == null || templates == null) {
            return null;
        }
        String templatePath = (String)page.getProperties().get("cq:template", String.class);
        if (templatePath == null) {
            return null;
        }
        return Template.forTemplatePath(templatePath, templates);
    }

    @SafeVarargs
    @Nullable
    public static <E extends Enum<E>> TemplatePathInfo forPage(@NotNull Page page, Class<E> ... templateEnums) {
        if (page == null || templateEnums == null) {
            return null;
        }
        String templatePath = (String)page.getProperties().get("cq:template", String.class);
        if (templatePath == null) {
            return null;
        }
        return Template.forTemplatePath(templatePath, templateEnums);
    }
}

